/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Subtract;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.Before;
import org.junit.Test;

public class TestSubtract
extends TestCase {
    Random r = new Random();
    ConstantExpression lt;
    ConstantExpression rt;
    Subtract op = new Subtract(new OperatorKey("", this.r.nextLong()));

    @Before
    public void setUp() throws Exception {
        this.lt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
        this.rt = new ConstantExpression(new OperatorKey("", this.r.nextLong()));
    }

    @Test
    public void testOperator() throws ExecException {
        byte[] types = new byte[]{120, 5, 50, 55, 25, 20, 10, 15, 100, 110};
        System.out.println("Testing Subtract operator");
        block12: for (byte type : types) {
            this.lt.setResultType(type);
            this.rt.setResultType(type);
            this.op.setLhs((ExpressionOperator)this.lt);
            this.op.setRhs((ExpressionOperator)this.rt);
            switch (type) {
                case 120: {
                    DataBag inpdb1 = GenRandomData.genRandSmallTupDataBag(this.r, 10, 100);
                    DataBag inpdb2 = GenRandomData.genRandSmallTupDataBag(this.r, 10, 100);
                    this.lt.setValue((Object)inpdb1);
                    this.rt.setValue((Object)inpdb2);
                    Result resdb = this.op.getNext(inpdb1);
                    TestSubtract.assertEquals((byte)resdb.returnStatus, (byte)2);
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpdb2);
                    resdb = this.op.getNext(inpdb1);
                    TestSubtract.assertEquals((byte)resdb.returnStatus, (byte)2);
                    this.lt.setValue((Object)inpdb1);
                    this.rt.setValue(null);
                    resdb = this.op.getNext(inpdb1);
                    TestSubtract.assertEquals((byte)resdb.returnStatus, (byte)2);
                    continue block12;
                }
                case 5: {
                    Boolean inpb1 = this.r.nextBoolean();
                    Boolean inpb2 = this.r.nextBoolean();
                    this.lt.setValue((Object)inpb1);
                    this.rt.setValue((Object)inpb2);
                    Result resb = this.op.getNext(inpb1);
                    TestSubtract.assertEquals((byte)resb.returnStatus, (byte)2);
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpb2);
                    resb = this.op.getNext(inpb1);
                    TestSubtract.assertEquals((byte)resb.returnStatus, (byte)2);
                    this.lt.setValue((Object)inpb1);
                    this.rt.setValue(null);
                    resb = this.op.getNext(inpb1);
                    TestSubtract.assertEquals((byte)resb.returnStatus, (byte)2);
                    continue block12;
                }
                case 50: {
                    DataByteArray inpba1 = GenRandomData.genRandDBA(this.r);
                    DataByteArray inpba2 = GenRandomData.genRandDBA(this.r);
                    this.lt.setValue((Object)inpba1);
                    this.rt.setValue((Object)inpba2);
                    Result resba = this.op.getNext(inpba1);
                    TestSubtract.assertEquals((byte)2, (byte)resba.returnStatus);
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpba2);
                    resba = this.op.getNext(inpba1);
                    TestSubtract.assertEquals((byte)resba.returnStatus, (byte)2);
                    this.lt.setValue((Object)inpba1);
                    this.rt.setValue(null);
                    resba = this.op.getNext(inpba1);
                    TestSubtract.assertEquals((byte)resba.returnStatus, (byte)2);
                    continue block12;
                }
                case 55: {
                    String inps1 = GenRandomData.genRandString(this.r);
                    String inps2 = GenRandomData.genRandString(this.r);
                    this.lt.setValue((Object)inps1);
                    this.rt.setValue((Object)inps2);
                    Result ress = this.op.getNext(inps1);
                    TestSubtract.assertEquals((byte)2, (byte)ress.returnStatus);
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inps2);
                    ress = this.op.getNext(inps1);
                    TestSubtract.assertEquals((byte)ress.returnStatus, (byte)2);
                    this.lt.setValue((Object)inps1);
                    this.rt.setValue(null);
                    ress = this.op.getNext(inps1);
                    TestSubtract.assertEquals((byte)ress.returnStatus, (byte)2);
                    continue block12;
                }
                case 25: {
                    Double inpd1 = this.r.nextDouble();
                    Double inpd2 = this.r.nextDouble();
                    this.lt.setValue((Object)inpd1);
                    this.rt.setValue((Object)inpd2);
                    Result resd = this.op.getNext(inpd1);
                    Number expected = new Double(inpd1 - inpd2);
                    TestSubtract.assertEquals((Object)expected, (Object)((Double)resd.result));
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpd2);
                    resd = this.op.getNext(inpd1);
                    TestSubtract.assertEquals(null, (Object)((Double)resd.result));
                    this.lt.setValue((Object)inpd1);
                    this.rt.setValue(null);
                    resd = this.op.getNext(inpd1);
                    TestSubtract.assertEquals(null, (Object)((Double)resd.result));
                    continue block12;
                }
                case 20: {
                    Float inpf1 = Float.valueOf(this.r.nextFloat());
                    Float inpf2 = Float.valueOf(this.r.nextFloat());
                    this.lt.setValue((Object)inpf1);
                    this.rt.setValue((Object)inpf2);
                    Result resf = this.op.getNext(inpf1);
                    Number expected = new Float(inpf1.floatValue() - inpf2.floatValue());
                    TestSubtract.assertEquals((Object)expected, (Object)((Float)resf.result));
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpf2);
                    resf = this.op.getNext(inpf1);
                    TestSubtract.assertEquals(null, (Object)((Float)resf.result));
                    this.lt.setValue((Object)inpf1);
                    this.rt.setValue(null);
                    resf = this.op.getNext(inpf1);
                    TestSubtract.assertEquals(null, (Object)((Float)resf.result));
                    continue block12;
                }
                case 10: {
                    Integer inpi1 = this.r.nextInt();
                    Integer inpi2 = this.r.nextInt();
                    this.lt.setValue((Object)inpi1);
                    this.rt.setValue((Object)inpi2);
                    Result resi = this.op.getNext(inpi1);
                    Number expected = new Integer(inpi1 - inpi2);
                    TestSubtract.assertEquals((Object)expected, (Object)((Integer)resi.result));
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpi2);
                    resi = this.op.getNext(inpi1);
                    TestSubtract.assertEquals(null, (Object)((Integer)resi.result));
                    this.lt.setValue((Object)inpi1);
                    this.rt.setValue(null);
                    resi = this.op.getNext(inpi1);
                    TestSubtract.assertEquals(null, (Object)((Integer)resi.result));
                    continue block12;
                }
                case 15: {
                    Long inpl1 = this.r.nextLong();
                    Long inpl2 = this.r.nextLong();
                    this.lt.setValue((Object)inpl1);
                    this.rt.setValue((Object)inpl2);
                    Result resl = this.op.getNext(inpl1);
                    Number expected = new Long(inpl1 - inpl2);
                    TestSubtract.assertEquals((Object)expected, (Object)((Long)resl.result));
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpl2);
                    resl = this.op.getNext(inpl1);
                    TestSubtract.assertEquals(null, (Object)((Long)resl.result));
                    this.lt.setValue((Object)inpl1);
                    this.rt.setValue(null);
                    resl = this.op.getNext(inpl1);
                    TestSubtract.assertEquals(null, (Object)((Long)resl.result));
                    continue block12;
                }
                case 100: {
                    Map<String, Object> inpm1 = GenRandomData.genRandMap(this.r, 10);
                    Map<String, Object> inpm2 = GenRandomData.genRandMap(this.r, 10);
                    this.lt.setValue(inpm1);
                    this.rt.setValue(inpm2);
                    Result resm = this.op.getNext(inpm1);
                    TestSubtract.assertEquals((byte)2, (byte)resm.returnStatus);
                    this.lt.setValue(null);
                    this.rt.setValue(inpm2);
                    resm = this.op.getNext(inpm1);
                    TestSubtract.assertEquals((byte)2, (byte)resm.returnStatus);
                    this.lt.setValue(inpm1);
                    this.rt.setValue(null);
                    resm = this.op.getNext(inpm1);
                    TestSubtract.assertEquals((byte)2, (byte)resm.returnStatus);
                    continue block12;
                }
                case 110: {
                    Tuple inpt1 = GenRandomData.genRandSmallBagTuple(this.r, 10, 100);
                    Tuple inpt2 = GenRandomData.genRandSmallBagTuple(this.r, 10, 100);
                    this.lt.setValue((Object)inpt1);
                    this.rt.setValue((Object)inpt2);
                    Result rest = this.op.getNext(inpt1);
                    TestSubtract.assertEquals((byte)2, (byte)rest.returnStatus);
                    this.lt.setValue(null);
                    this.rt.setValue((Object)inpt2);
                    rest = this.op.getNext(inpt1);
                    TestSubtract.assertEquals((byte)2, (byte)rest.returnStatus);
                    this.lt.setValue((Object)inpt1);
                    this.rt.setValue(null);
                    rest = this.op.getNext(inpt1);
                    TestSubtract.assertEquals((byte)2, (byte)rest.returnStatus);
                    continue block12;
                }
            }
        }
    }
}

