/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.TupleFormat;

public class TestTupleFormat
extends TestCase {
    public void testTupleFormat() {
        try {
            Tuple tuple = TupleFactory.getInstance().newTuple(7);
            tuple.set(0, (Object)12);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pig", "scalability");
            tuple.set(1, map);
            tuple.set(2, null);
            tuple.set(3, (Object)12L);
            tuple.set(4, (Object)Float.valueOf(1.2f));
            Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
            innerTuple.set(0, (Object)"innerTuple");
            tuple.set(5, (Object)innerTuple);
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            bag.add(innerTuple);
            tuple.set(6, (Object)bag);
            TestTupleFormat.assertEquals((String)"(12,[pig#scalability],,12L,1.2F,(innerTuple),{(innerTuple)})", (String)TupleFormat.format((Tuple)tuple));
        }
        catch (ExecException e) {
            e.printStackTrace();
            TestTupleFormat.fail();
        }
    }
}

