/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckerException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.junit.Before;
import org.junit.Test;

public class TestTypeChecking
extends TestCase {
    final String FILE_BASE_LOCATION = "test/org/apache/pig/test/data/DotFiles/";
    LogicalPlanTester planTester = new LogicalPlanTester();

    @Before
    public void setUp() {
        this.planTester.reset();
    }

    @Test
    public void testSimple1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.buildPlan("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        LogicalPlan plan = this.planTester.buildPlan("b = distinct a ;");
        this.planTester.typeCheckAgainstDotFile(plan, "test/org/apache/pig/test/data/DotFiles/plan1.dot");
    }

    @Test
    public void testByScript1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.typeCheckUsingDotFile("test/org/apache/pig/test/data/DotFiles/testScript1.dot");
    }

    @Test
    public void testByScript2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.typeCheckUsingDotFile("test/org/apache/pig/test/data/DotFiles/testScript2.dot");
    }

    @Test
    public void testByScript5() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.typeCheckUsingDotFile("test/org/apache/pig/test/data/DotFiles/testScript5.dot");
    }

    @Test
    public void testByScript6() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.typeCheckUsingDotFile("test/org/apache/pig/test/data/DotFiles/testScript6.dot");
    }

    public void testSUM1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.buildPlan("a = load '/user/pig/tests/data/singlefile/studenttab10k' as (name:chararray, age:int, gpa:double);");
        LogicalPlan plan1 = this.planTester.buildPlan("b = foreach a generate (long)age as age:long, (int)gpa as gpa:int;");
        LogicalPlan plan2 = this.planTester.buildPlan("c = foreach b generate SUM(age), SUM(gpa);");
        try {
            this.planTester.typeCheckPlan(plan2);
        }
        catch (PlanValidationException e) {
            Throwable t = e.getCause();
            if (!(t instanceof TypeCheckerException)) {
                System.out.println("t: " + t);
                Assert.fail();
            }
            return;
        }
        Assert.fail();
    }

    public void testSUM2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.buildPlan("a = group (load '\" + tmpFile + \"') by ($0,$1);");
        LogicalPlan plan1 = this.planTester.buildPlan("b = foreach a generate flatten(group), SUM($1.$2);");
        this.planTester.typeCheckPlan(plan1);
    }

    public void testGenerate1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        this.planTester.buildPlan("a = load '/user/pig/tests/data/singlefile/studenttab10k' as (name:chararray, age:int, gpa:double);");
        LogicalPlan plan1 = this.planTester.buildPlan("b = foreach a generate 1 + 0.2f + 253645L, gpa+1; ");
        this.planTester.typeCheckPlan(plan1);
    }
}

