/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckingValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.junit.Test;

public class TestTypeCheckingValidatorNoSchema
extends TestCase {
    @Test
    public void testUnion1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        load2.setEnforcedSchema(null);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOUnion union = new LOUnion(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)union);
        plan.connect((Operator)load1, (Operator)union);
        plan.connect((Operator)load2, (Operator)union);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        Schema outputSchema = union.getSchema();
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)outputSchema, null);
    }

    @Test
    public void testUnion2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        String[] aliases = new String[]{"a", "b", "c"};
        byte[] types = new byte[]{10, 15, 50};
        Schema schema1 = TypeCheckingTestUtil.genFlatSchema(aliases, types);
        load1.setEnforcedSchema(schema1);
        load2.setEnforcedSchema(null);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOUnion union = new LOUnion(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)union);
        plan.connect((Operator)load1, (Operator)union);
        plan.connect((Operator)load2, (Operator)union);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        Schema outputSchema = union.getSchema();
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)outputSchema, null);
    }

    @Test
    public void testSplitWithInnerPlan1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LONotEqual notequal1 = new LONotEqual(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)notequal1);
        innerPlan1.connect((Operator)project11, (Operator)notequal1);
        innerPlan1.connect((Operator)project12, (Operator)notequal1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const21.setType((byte)15);
        LOLesserThanEqual lesser21 = new LOLesserThanEqual(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)lesser21);
        innerPlan2.connect((Operator)project21, (Operator)lesser21);
        innerPlan2.connect((Operator)const21, (Operator)lesser21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        LOSplit split1 = new LOSplit(plan, TypeCheckingTestUtil.genNewOperatorKey(), new ArrayList());
        LOSplitOutput splitOutput1 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 0, innerPlan1);
        split1.addOutput((LogicalOperator)splitOutput1);
        LOSplitOutput splitOutput2 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 1, innerPlan2);
        split1.addOutput((LogicalOperator)splitOutput2);
        plan.add((Operator)load1);
        plan.add((Operator)split1);
        plan.add((Operator)splitOutput1);
        plan.add((Operator)splitOutput2);
        plan.connect((Operator)load1, (Operator)split1);
        plan.connect((Operator)split1, (Operator)splitOutput1);
        plan.connect((Operator)split1, (Operator)splitOutput2);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)split1.getSchema(), null);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)splitOutput1.getSchema(), null);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)splitOutput2.getSchema(), null);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan1.getSingleLeafPlanOutputType(), (byte)5);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan2.getSingleLeafPlanOutputType(), (byte)5);
    }

    @Test
    public void testSplitWithInnerPlan2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LONotEqual notequal1 = new LONotEqual(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)notequal1);
        innerPlan1.connect((Operator)project11, (Operator)notequal1);
        innerPlan1.connect((Operator)project12, (Operator)notequal1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const21.setType((byte)15);
        LOAdd add21 = new LOAdd(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        LOConst const22 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"hoho");
        const22.setType((byte)55);
        LOSubtract subtract21 = new LOSubtract(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)add21);
        innerPlan2.add((Operator)const22);
        innerPlan2.add((Operator)subtract21);
        innerPlan2.connect((Operator)project21, (Operator)add21);
        innerPlan2.connect((Operator)const21, (Operator)add21);
        innerPlan2.connect((Operator)add21, (Operator)subtract21);
        innerPlan2.connect((Operator)const22, (Operator)subtract21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        LOSplit split1 = new LOSplit(plan, TypeCheckingTestUtil.genNewOperatorKey(), new ArrayList());
        LOSplitOutput splitOutput1 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 0, innerPlan1);
        split1.addOutput((LogicalOperator)splitOutput1);
        LOSplitOutput splitOutput2 = new LOSplitOutput(plan, TypeCheckingTestUtil.genNewOperatorKey(), 1, innerPlan2);
        split1.addOutput((LogicalOperator)splitOutput2);
        plan.add((Operator)load1);
        plan.add((Operator)split1);
        plan.add((Operator)splitOutput1);
        plan.add((Operator)splitOutput2);
        plan.connect((Operator)load1, (Operator)split1);
        plan.connect((Operator)split1, (Operator)splitOutput1);
        plan.connect((Operator)split1, (Operator)splitOutput2);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        try {
            TypeCheckingValidator typeValidator = new TypeCheckingValidator();
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidatorNoSchema.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
    }

    @Test
    public void testDistinct1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        LODistinct distinct1 = new LODistinct(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)distinct1);
        plan.connect((Operator)load1, (Operator)distinct1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)distinct1.getSchema(), null);
    }

    @Test
    public void testSort1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOProject project12 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project11.setSentinel(true);
        LOMultiply mul1 = new LOMultiply(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)project12);
        innerPlan1.add((Operator)mul1);
        innerPlan1.connect((Operator)project11, (Operator)mul1);
        innerPlan1.connect((Operator)project12, (Operator)mul1);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOConst const21 = new LOConst(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const21.setType((byte)15);
        LOMod mod21 = new LOMod(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)const21);
        innerPlan2.add((Operator)mod21);
        innerPlan2.connect((Operator)project21, (Operator)mod21);
        innerPlan2.connect((Operator)const21, (Operator)mod21);
        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
        innerPlans.add(innerPlan1);
        innerPlans.add(innerPlan2);
        ArrayList<Boolean> ascList = new ArrayList<Boolean>();
        ascList.add(true);
        ascList.add(true);
        LOSort sort1 = new LOSort(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlans, ascList, null);
        plan.add((Operator)load1);
        plan.add((Operator)sort1);
        plan.connect((Operator)load1, (Operator)sort1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)sort1.getSchema(), null);
    }

    @Test
    public void testFilter1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), ConfigurationUtil.toConfiguration((Properties)new Properties()));
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan = new LogicalPlan();
        LOProject project1 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project1.setSentinel(true);
        LOProject project2 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project2.setSentinel(true);
        LOAdd add1 = new LOAdd(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        LOConst const1 = new LOConst(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)10);
        const1.setType((byte)15);
        LOGreaterThan gt1 = new LOGreaterThan(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan.add((Operator)project1);
        innerPlan.add((Operator)project2);
        innerPlan.add((Operator)add1);
        innerPlan.add((Operator)const1);
        innerPlan.add((Operator)gt1);
        innerPlan.connect((Operator)project1, (Operator)add1);
        innerPlan.connect((Operator)project2, (Operator)add1);
        innerPlan.connect((Operator)add1, (Operator)gt1);
        innerPlan.connect((Operator)const1, (Operator)gt1);
        LOFilter filter1 = new LOFilter(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlan);
        plan.add((Operator)load1);
        plan.add((Operator)filter1);
        plan.connect((Operator)load1, (Operator)filter1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)filter1.getSchema(), null);
    }

    @Test
    public void testFilter2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        String pigStorage = PigStorage.class.getName();
        LOLoad load1 = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), ConfigurationUtil.toConfiguration((Properties)new Properties()));
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan = new LogicalPlan();
        LOProject project1 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project1.setSentinel(true);
        LOProject project2 = new LOProject(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project2.setSentinel(true);
        LOAdd add1 = new LOAdd(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        LOConst const1 = new LOConst(innerPlan, TypeCheckingTestUtil.genNewOperatorKey(), (Object)"10");
        const1.setType((byte)55);
        LOGreaterThan gt1 = new LOGreaterThan(innerPlan, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan.add((Operator)project1);
        innerPlan.add((Operator)project2);
        innerPlan.add((Operator)add1);
        innerPlan.add((Operator)const1);
        innerPlan.add((Operator)gt1);
        innerPlan.connect((Operator)project1, (Operator)add1);
        innerPlan.connect((Operator)project2, (Operator)add1);
        innerPlan.connect((Operator)add1, (Operator)gt1);
        innerPlan.connect((Operator)const1, (Operator)gt1);
        LOFilter filter1 = new LOFilter(plan, TypeCheckingTestUtil.genNewOperatorKey(), innerPlan);
        plan.add((Operator)load1);
        plan.add((Operator)filter1);
        plan.connect((Operator)load1, (Operator)filter1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        try {
            typeValidator.validate(plan, collector);
            TestTypeCheckingValidatorNoSchema.fail((String)"Exception expected");
        }
        catch (PlanValidationException pve) {
            // empty catch block
        }
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (!collector.hasError()) {
            throw new AssertionError((Object)"Expect an error");
        }
    }

    @Test
    public void testCross1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        Schema inputSchema1 = null;
        ArrayList<Schema.FieldSchema> fsList1 = new ArrayList<Schema.FieldSchema>();
        fsList1.add(new Schema.FieldSchema("field1a", 10));
        fsList1.add(new Schema.FieldSchema("field2a", 50));
        inputSchema1 = new Schema(fsList1);
        load1.setEnforcedSchema(inputSchema1);
        load2.setEnforcedSchema(null);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOCross cross = new LOCross(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cross);
        plan.connect((Operator)load1, (Operator)cross);
        plan.connect((Operator)load2, (Operator)cross);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)cross.getSchema(), null);
    }

    @Test
    public void testCross2() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        load2.setEnforcedSchema(null);
        ArrayList<LOLoad> inputList = new ArrayList<LOLoad>();
        inputList.add(load1);
        inputList.add(load2);
        LOCross cross = new LOCross(plan, TypeCheckingTestUtil.genNewOperatorKey());
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cross);
        plan.connect((Operator)load1, (Operator)cross);
        plan.connect((Operator)load2, (Operator)cross);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)cross.getSchema(), null);
    }

    @Test
    public void testCOGroupByAtom1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        load2.setEnforcedSchema(null);
        LogicalPlan innerPlan11 = new LogicalPlan();
        LOProject project111 = new LOProject(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project111.setSentinel(true);
        LOConst const111 = new LOConst(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const111.setType((byte)20);
        LOSubtract subtract111 = new LOSubtract(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan11.add((Operator)project111);
        innerPlan11.add((Operator)const111);
        innerPlan11.add((Operator)subtract111);
        innerPlan11.connect((Operator)project111, (Operator)subtract111);
        innerPlan11.connect((Operator)const111, (Operator)subtract111);
        LogicalPlan innerPlan12 = new LogicalPlan();
        LOProject project121 = new LOProject(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load2, Integer.valueOf(0));
        project121.setSentinel(true);
        LOConst const121 = new LOConst(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const121.setType((byte)10);
        LOSubtract subtract121 = new LOSubtract(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan12.add((Operator)project121);
        innerPlan12.add((Operator)const121);
        innerPlan12.add((Operator)subtract121);
        innerPlan12.connect((Operator)project121, (Operator)subtract121);
        innerPlan12.connect((Operator)const121, (Operator)subtract121);
        ArrayList<LOLoad> inputs = new ArrayList<LOLoad>();
        inputs.add(load1);
        inputs.add(load2);
        MultiMap maps = new MultiMap();
        maps.put((Object)load1, (Object)innerPlan11);
        maps.put((Object)load2, (Object)innerPlan12);
        boolean[] isInner = new boolean[inputs.size()];
        for (int i = 0; i < isInner.length; ++i) {
            isInner[i] = false;
        }
        LOCogroup cogroup1 = new LOCogroup(plan, TypeCheckingTestUtil.genNewOperatorKey(), maps, isInner);
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cogroup1);
        plan.connect((Operator)load1, (Operator)cogroup1);
        plan.connect((Operator)load2, (Operator)cogroup1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = cogroup1.getSchema();
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)endResultSchema.getField((int)1).schema, null);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)endResultSchema.getField((int)2).schema, null);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan11.getSingleLeafPlanOutputType(), (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan12.getSingleLeafPlanOutputType(), (byte)20);
    }

    @Test
    public void testCOGroupByTuple1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        LOLoad load2 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        load2.setEnforcedSchema(null);
        LogicalPlan innerPlan11 = new LogicalPlan();
        LOProject project111 = new LOProject(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project111.setSentinel(true);
        LOConst const111 = new LOConst(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const111.setType((byte)20);
        LOSubtract subtract111 = new LOSubtract(innerPlan11, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan11.add((Operator)project111);
        innerPlan11.add((Operator)const111);
        innerPlan11.add((Operator)subtract111);
        innerPlan11.connect((Operator)project111, (Operator)subtract111);
        innerPlan11.connect((Operator)const111, (Operator)subtract111);
        LogicalPlan innerPlan21 = new LogicalPlan();
        LOProject project211 = new LOProject(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project211.setSentinel(true);
        LOProject project212 = new LOProject(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project212.setSentinel(true);
        LOAdd add211 = new LOAdd(innerPlan21, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan21.add((Operator)project211);
        innerPlan21.add((Operator)project212);
        innerPlan21.add((Operator)add211);
        innerPlan21.connect((Operator)project211, (Operator)add211);
        innerPlan21.connect((Operator)project212, (Operator)add211);
        LogicalPlan innerPlan12 = new LogicalPlan();
        LOProject project121 = new LOProject(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load2, Integer.valueOf(0));
        project121.setSentinel(true);
        LOConst const121 = new LOConst(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const121.setType((byte)10);
        LOSubtract subtract121 = new LOSubtract(innerPlan12, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan12.add((Operator)project121);
        innerPlan12.add((Operator)const121);
        innerPlan12.add((Operator)subtract121);
        innerPlan12.connect((Operator)project121, (Operator)subtract121);
        innerPlan12.connect((Operator)const121, (Operator)subtract121);
        LogicalPlan innerPlan22 = new LogicalPlan();
        LOConst const122 = new LOConst(innerPlan22, TypeCheckingTestUtil.genNewOperatorKey(), (Object)26);
        const122.setType((byte)10);
        innerPlan22.add((Operator)const122);
        ArrayList<LOLoad> inputs = new ArrayList<LOLoad>();
        inputs.add(load1);
        inputs.add(load2);
        MultiMap maps = new MultiMap();
        maps.put((Object)load1, (Object)innerPlan11);
        maps.put((Object)load1, (Object)innerPlan21);
        maps.put((Object)load2, (Object)innerPlan12);
        maps.put((Object)load2, (Object)innerPlan22);
        boolean[] isInner = new boolean[inputs.size()];
        for (int i = 0; i < isInner.length; ++i) {
            isInner[i] = false;
        }
        LOCogroup cogroup1 = new LOCogroup(plan, TypeCheckingTestUtil.genNewOperatorKey(), maps, isInner);
        plan.add((Operator)load1);
        plan.add((Operator)load2);
        plan.add((Operator)cogroup1);
        plan.connect((Operator)load1, (Operator)cogroup1);
        plan.connect((Operator)load2, (Operator)cogroup1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = cogroup1.getSchema();
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)110);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)0).schema.getField((int)0).type, (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)0).schema.getField((int)1).type, (byte)25);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)120);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)2).type, (byte)120);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)endResultSchema.getField((int)1).schema, null);
        TestTypeCheckingValidatorNoSchema.assertEquals((Object)endResultSchema.getField((int)2).schema, null);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan11.getSingleLeafPlanOutputType(), (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan21.getSingleLeafPlanOutputType(), (byte)25);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan12.getSingleLeafPlanOutputType(), (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)innerPlan22.getSingleLeafPlanOutputType(), (byte)25);
    }

    @Test
    public void testForEachGenerate1() throws Throwable {
        TypeCheckingTestUtil.printCurrentMethodName();
        LogicalPlan plan = new LogicalPlan();
        LOLoad load1 = TypeCheckingTestUtil.genDummyLOLoad(plan);
        load1.setEnforcedSchema(null);
        LogicalPlan innerPlan1 = new LogicalPlan();
        LOProject project11 = new LOProject(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project11.setSentinel(true);
        LOConst const11 = new LOConst(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey(), (Object)Float.valueOf(26.0f));
        const11.setType((byte)20);
        LOSubtract subtract11 = new LOSubtract(innerPlan1, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan1.add((Operator)project11);
        innerPlan1.add((Operator)const11);
        innerPlan1.add((Operator)subtract11);
        innerPlan1.connect((Operator)project11, (Operator)subtract11);
        innerPlan1.connect((Operator)const11, (Operator)subtract11);
        LogicalPlan innerPlan2 = new LogicalPlan();
        LOProject project21 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(0));
        project21.setSentinel(true);
        LOProject project22 = new LOProject(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey(), (LogicalOperator)load1, Integer.valueOf(1));
        project21.setSentinel(true);
        LOAdd add21 = new LOAdd(innerPlan2, TypeCheckingTestUtil.genNewOperatorKey());
        innerPlan2.add((Operator)project21);
        innerPlan2.add((Operator)project22);
        innerPlan2.add((Operator)add21);
        innerPlan2.connect((Operator)project21, (Operator)add21);
        innerPlan2.connect((Operator)project22, (Operator)add21);
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        generatePlans.add(innerPlan1);
        generatePlans.add(innerPlan2);
        ArrayList<Boolean> flattens = new ArrayList<Boolean>();
        flattens.add(true);
        flattens.add(false);
        LOForEach foreach1 = new LOForEach(plan, TypeCheckingTestUtil.genNewOperatorKey(), generatePlans, flattens);
        plan.add((Operator)load1);
        plan.add((Operator)foreach1);
        plan.connect((Operator)load1, (Operator)foreach1);
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new AssertionError((Object)"Expect no error");
        }
        Schema endResultSchema = foreach1.getSchema();
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)0).type, (byte)20);
        TestTypeCheckingValidatorNoSchema.assertEquals((byte)endResultSchema.getField((int)1).type, (byte)25);
    }
}

