/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestUDFContext
extends TestCase {
    static MiniCluster cluster = null;

    protected void setUp() throws Exception {
        cluster = MiniCluster.buildCluster();
    }

    @Test
    public void testUDFContext() throws Exception {
        Util.createInputFile(cluster, "a.txt", new String[]{"dumb"});
        Util.createInputFile(cluster, "b.txt", new String[]{"dumber"});
        FileLocalizer.deleteTempFiles();
        PigServer pig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
        String[] statement = new String[]{"A = LOAD 'a.txt' USING org.apache.pig.test.utils.UDFContextTestLoader('joe');", "B = LOAD 'b.txt' USING org.apache.pig.test.utils.UDFContextTestLoader('jane');", "C = union A, B;", "D = FOREACH C GENERATE $0, $1, org.apache.pig.test.utils.UDFContextTestEvalFunc($0), org.apache.pig.test.utils.UDFContextTestEvalFunc2($0);"};
        File tmpFile = File.createTempFile("temp_jira_851", ".pig");
        FileWriter writer = new FileWriter(tmpFile);
        for (String line : statement) {
            writer.write(line + "\n");
        }
        writer.close();
        pig.registerScript(tmpFile.getAbsolutePath());
        Iterator iterator = pig.openIterator("D");
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            if ("dumb".equals(tuple.get(0).toString())) {
                TestUDFContext.assertEquals((String)tuple.get(1).toString(), (String)"joe");
            } else if ("dumber".equals(tuple.get(0).toString())) {
                TestUDFContext.assertEquals((String)tuple.get(1).toString(), (String)"jane");
            }
            TestUDFContext.assertEquals((Object)Integer.valueOf(tuple.get(2).toString()), (Object)new Integer(5));
            TestUDFContext.assertEquals((String)tuple.get(3).toString(), (String)"five");
        }
    }
}

