/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogToPhyTranslationVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.experimental.logical.optimizer.PlanPrinter;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.parser.QueryParser;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.tools.grunt.GruntParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static BagFactory mBagFactory = BagFactory.getInstance();
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();

    public static Tuple loadFlatTuple(Tuple t, int[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)new Integer(input[i]));
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, String[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)input[i]);
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, DataByteArray[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)input[i]);
        }
        return t;
    }

    public static Tuple loadNestTuple(Tuple t, int[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, (Object)input[i]);
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static Tuple loadNestTuple(Tuple t, long[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, (Object)new Long(input[i]));
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static <T> Tuple loadNestTuple(Tuple t, T[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, input[i]);
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static <T> void addToTuple(Tuple t, T[] b) {
        for (int i = 0; i < b.length; ++i) {
            t.append(b[i]);
        }
    }

    public static <T> Tuple createTuple(T[] s) {
        Tuple t = mTupleFactory.newTuple();
        Util.addToTuple(t, s);
        return t;
    }

    public static DataBag createBag(Tuple[] t) {
        DataBag b = mBagFactory.newDefaultBag();
        for (int i = 0; i < t.length; ++i) {
            b.add(t[i]);
        }
        return b;
    }

    public static <T> DataBag createBagOfOneColumn(T[] input) throws ExecException {
        DataBag result = mBagFactory.newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple t = mTupleFactory.newTuple(1);
            t.set(0, input[i]);
            result.add(t);
        }
        return result;
    }

    public static Map<String, Object> createMap(String[] contents) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int i = 0; i < contents.length; i += 2) {
            m.put(contents[i], contents[i + 1]);
        }
        return m;
    }

    public static <T> DataByteArray[] toDataByteArrays(T[] input) {
        DataByteArray[] dbas = new DataByteArray[input.length];
        for (int i = 0; i < input.length; ++i) {
            dbas[i] = input[i] == null ? null : new DataByteArray(input[i].toString().getBytes());
        }
        return dbas;
    }

    public static Tuple loadNestTuple(Tuple t, int[][] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            Tuple f = Util.loadFlatTuple(TupleFactory.getInstance().newTuple(input[i].length), input[i]);
            bag.add(f);
            t.set(i, (Object)bag);
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, String[][] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            Tuple f = Util.loadTuple(TupleFactory.getInstance().newTuple(input[i].length), input[i]);
            bag.add(f);
            t.set(i, (Object)bag);
        }
        return t;
    }

    public static File createInputFile(String tmpFilenamePrefix, String tmpFilenameSuffix, String[] inputData) throws IOException {
        File f = File.createTempFile(tmpFilenamePrefix, tmpFilenameSuffix);
        f.deleteOnExit();
        Util.writeToFile(f, inputData);
        return f;
    }

    public static File createLocalInputFile(String filename, String[] inputData) throws IOException {
        File f = new File(filename);
        f.deleteOnExit();
        Util.writeToFile(f, inputData);
        return f;
    }

    private static void writeToFile(File f, String[] inputData) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        for (int i = 0; i < inputData.length; ++i) {
            pw.println(inputData[i]);
        }
        pw.close();
    }

    public static void createInputFile(MiniCluster miniCluster, String fileName, String[] inputData) throws IOException {
        FileSystem fs = miniCluster.getFileSystem();
        Util.createInputFile(fs, fileName, inputData);
    }

    public static void createInputFile(FileSystem fs, String fileName, String[] inputData) throws IOException {
        if (fs.exists(new Path(fileName))) {
            throw new IOException("File " + fileName + " already exists on the minicluster");
        }
        FSDataOutputStream stream = fs.create(new Path(fileName));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
        for (int i = 0; i < inputData.length; ++i) {
            pw.println(inputData[i]);
        }
        pw.close();
    }

    public static OutputStream createInputFile(MiniCluster cluster, String fileName) throws IOException {
        FileSystem fs = cluster.getFileSystem();
        if (fs.exists(new Path(fileName))) {
            throw new IOException("File " + fileName + " already exists on the minicluster");
        }
        return fs.create(new Path(fileName));
    }

    public static void deleteFile(MiniCluster miniCluster, String fileName) throws IOException {
        FileSystem fs = miniCluster.getFileSystem();
        fs.delete(new Path(fileName), true);
    }

    public static void deleteFile(PigContext pigContext, String fileName) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(fileName), true);
    }

    public static boolean exists(PigContext pigContext, String fileName) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(fileName));
    }

    public static void checkQueryOutputs(Iterator<Tuple> actualResults, Tuple[] expectedResults) {
        for (Tuple expected : expectedResults) {
            Tuple actual = actualResults.next();
            Assert.assertEquals((String)expected.toString(), (String)actual.toString());
        }
    }

    public static void copyFromLocalToCluster(MiniCluster cluster, String localFileName, String fileNameOnCluster) throws IOException {
        PigServer ps = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
        String script = "fs -put " + localFileName + " " + fileNameOnCluster;
        GruntParser parser = new GruntParser((Reader)new StringReader(script));
        parser.setInteractive(false);
        parser.setParams(ps);
        try {
            parser.parseStopOnError();
        }
        catch (org.apache.pig.tools.pigscript.parser.ParseException e) {
            throw new IOException(e);
        }
    }

    public static void copyFromClusterToLocal(MiniCluster cluster, String fileNameOnCluster, String localFileName) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(localFileName));
        FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)cluster.getProperties()));
        if (!fs.exists(new Path(fileNameOnCluster))) {
            throw new IOException("File " + fileNameOnCluster + " does not exists on the minicluster");
        }
        String line = null;
        FileStatus fst = fs.getFileStatus(new Path(fileNameOnCluster));
        if (fst.isDir()) {
            throw new IOException("Only files from cluster can be copied locally, " + fileNameOnCluster + " is a directory");
        }
        FSDataInputStream stream = fs.open(new Path(fileNameOnCluster));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream));
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        reader.close();
        writer.close();
    }

    public static void printQueryOutput(Iterator<Tuple> actualResults, Tuple[] expectedResults) {
        System.out.println("Expected :");
        for (Tuple expected : expectedResults) {
            System.out.println(expected.toString());
        }
        System.out.println("---End----");
        System.out.println("Actual :");
        while (actualResults.hasNext()) {
            System.out.println(actualResults.next().toString());
        }
        System.out.println("---End----");
    }

    public static String encodeEscape(String str) {
        String regex = "\\\\";
        String replacement = Matcher.quoteReplacement("\\\\");
        return str.replaceAll(regex, replacement);
    }

    public static String generateURI(String filename, PigContext context) throws IOException {
        if (context.getExecType() == ExecType.MAPREDUCE) {
            return FileLocalizer.hadoopify((String)filename, (PigContext)context);
        }
        if (context.getExecType() == ExecType.LOCAL) {
            return filename;
        }
        throw new IllegalStateException("ExecType: " + context.getExecType());
    }

    public static Schema getSchemaFromString(String schemaString) throws ParseException {
        return Util.getSchemaFromString(schemaString, (byte)50);
    }

    static Schema getSchemaFromString(String schemaString, byte defaultType) throws ParseException {
        ByteArrayInputStream stream = new ByteArrayInputStream(schemaString.getBytes());
        QueryParser queryParser = new QueryParser((InputStream)stream);
        Schema schema = queryParser.TupleSchema();
        Schema.setSchemaDefaultType((Schema)schema, (byte)defaultType);
        return schema;
    }

    public static Object getPigConstant(String pigConstantAsString) throws ParseException {
        ByteArrayInputStream stream = new ByteArrayInputStream(pigConstantAsString.getBytes());
        QueryParser queryParser = new QueryParser((InputStream)stream);
        return queryParser.Datum();
    }

    public static List<Tuple> getTuplesFromConstantTupleStrings(String[] tupleConstants) throws ParseException {
        ArrayList<Tuple> result = new ArrayList<Tuple>(tupleConstants.length);
        for (int i = 0; i < tupleConstants.length; ++i) {
            result.add((Tuple)Util.getPigConstant(tupleConstants[i]));
        }
        return result;
    }

    public static File createFile(String[] data) throws Exception {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        for (int i = 0; i < data.length; ++i) {
            pw.println(data[i]);
        }
        pw.close();
        return f;
    }

    public static PhysicalPlan buildPhysicalPlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp, PigContext pc) throws Exception {
        LogToPhyTranslationVisitor visitor = new LogToPhyTranslationVisitor(lp);
        visitor.setPigContext(pc);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    public static MROperPlan buildMRPlan(PhysicalPlan pp, PigContext pc) throws Exception {
        MRCompiler comp = new MRCompiler(pp, pc);
        comp.compile();
        return comp.getMRPlan();
    }

    public static void registerMultiLineQuery(PigServer pigServer, String query) throws IOException {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        pw.println(query);
        pw.close();
        pigServer.registerScript(f.getCanonicalPath());
    }

    public static int executeJavaCommand(String cmd) throws Exception {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            String fileSeparator = System.getProperty("file.separator");
            cmd = javaHome + fileSeparator + "bin" + fileSeparator + cmd;
        }
        Process cmdProc = Runtime.getRuntime().exec(cmd);
        cmdProc.waitFor();
        return cmdProc.exitValue();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Util.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static void createInputFile(PigContext pigContext, String fileName, String[] input) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        Util.createInputFile(FileSystem.get((Configuration)conf), fileName, input);
    }

    public static void printPlan(LogicalPlan logicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        PlanPrinter pp = new PlanPrinter((OperatorPlan)logicalPlan, ps);
        pp.visit();
        System.err.println(out.toString());
    }

    public static void printPlan(org.apache.pig.impl.logicalLayer.LogicalPlan logicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        logicalPlan.explain(ps, "text", true);
        System.err.println(out.toString());
    }

    public static void printPlan(PhysicalPlan physicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        physicalPlan.explain(ps, "text", true);
        System.err.println(out.toString());
    }
}

