/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumulatorBagCount
extends EvalFunc<Integer>
implements Accumulator<Integer> {
    int count = 0;

    public void accumulate(Tuple tuple) throws IOException {
        DataBag databag = (DataBag)tuple.get(0);
        if (databag == null) {
            return;
        }
        Iterator iterator = databag.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++this.count;
        }
    }

    public Integer getValue() {
        return new Integer(this.count);
    }

    public void cleanup() {
        this.count = 0;
    }

    public Integer exec(Tuple tuple) throws IOException {
        throw new IOException("exec() should not be called.");
    }
}

