/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.pig.backend.datastorage.SeekableInputStream;

public class LocalSeekableInputStream
extends SeekableInputStream {
    protected RandomAccessFile file;
    protected long curMark;

    public LocalSeekableInputStream(File file) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, "r");
        this.curMark = 0L;
    }

    public void seek(long offset, SeekableInputStream.FLAGS whence) throws IOException {
        long targetPos;
        switch (whence) {
            case SEEK_SET: {
                targetPos = offset;
                break;
            }
            case SEEK_CUR: {
                targetPos = this.file.getFilePointer() + offset;
                break;
            }
            case SEEK_END: {
                targetPos = this.file.length() + offset;
                break;
            }
            default: {
                throw new IOException("Invalid seek option: " + whence);
            }
        }
        this.file.seek(targetPos);
    }

    public long tell() throws IOException {
        return this.file.getFilePointer();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public int read(byte[] b) throws IOException {
        return this.file.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    public int available() throws IOException {
        return (int)(this.file.length() - this.file.getFilePointer());
    }

    public long skip(long n) throws IOException {
        long skipped = 0L;
        if (n > 0L) {
            skipped = this.file.length() - this.tell();
            this.seek(n, SeekableInputStream.FLAGS.SEEK_CUR);
        }
        return skipped;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public void mark(int readlimit) {
        try {
            this.curMark = this.tell();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        this.seek(this.curMark, SeekableInputStream.FLAGS.SEEK_SET);
    }

    public boolean markSupported() {
        return true;
    }
}

