/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.OperatorKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHelper {
    public static int dispAfterNumTuples = 1000;

    public static boolean bagContains(DataBag db, Tuple t) {
        Iterator iter = db.iterator();
        for (Tuple tuple : db) {
            if (tuple.compareTo((Object)t) != 0 && !TestHelper.tupleEquals(tuple, t)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareBags(DataBag db1, DataBag db2) {
        if (db1.size() != db2.size()) {
            return false;
        }
        int i = -1;
        boolean equal = true;
        for (Tuple tuple : db2) {
            boolean contains = false;
            for (Tuple tuple2 : db1) {
                if (tuple.compareTo((Object)tuple2) != 0) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            equal = false;
            break;
        }
        return equal;
    }

    public static DataBag projectBag(DataBag db2, int i) throws ExecException {
        DataBag ret = DefaultBagFactory.getInstance().newDefaultBag();
        for (Tuple tuple : db2) {
            Object o = tuple.get(i);
            DefaultTuple t1 = new DefaultTuple();
            t1.append(o);
            ret.add((Tuple)t1);
        }
        return ret;
    }

    public static DataBag projectBag(DataBag db2, int[] fields) throws ExecException {
        DataBag ret = DefaultBagFactory.getInstance().newDefaultBag();
        for (Tuple tuple : db2) {
            DefaultTuple t1 = new DefaultTuple();
            for (int fld : fields) {
                Object o = tuple.get(fld);
                t1.append(o);
            }
            ret.add((Tuple)t1);
        }
        return ret;
    }

    public static int compareInputStreams(InputStream exp, InputStream act) throws IOException {
        byte[] bExp = new byte[4096];
        byte[] bAct = new byte[4096];
        int inLen = -1;
        while (act.read(bAct) != -1) {
            exp.read(bExp);
            int cmp = TestHelper.compareByteArray(bExp, bAct);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static int compareByteArray(byte[] b1, byte[] b2) {
        if (b1.length > b2.length) {
            return 1;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] > b2[i]) {
                return 1;
            }
            if (b1[i] >= b2[i]) continue;
            return -1;
        }
        return 0;
    }

    public static boolean areFilesSame(FileSpec expLocal, FileSpec actHadoop, PigContext pc) throws ExecException, IOException {
        Random r = new Random();
        POLoad ldExp = new POLoad(new OperatorKey("", r.nextLong()));
        ldExp.setPc(pc);
        ldExp.setLFile(expLocal);
        POLoad ldAct = new POLoad(new OperatorKey("", r.nextLong()));
        ldAct.setPc(pc);
        ldAct.setLFile(actHadoop);
        Tuple t = null;
        int numActTuples = -1;
        DataBag bagAct = DefaultBagFactory.getInstance().newDefaultBag();
        Result resAct = null;
        while (true) {
            resAct = ldAct.getNext(t);
            if (resAct.returnStatus == 3) break;
            ++numActTuples;
            bagAct.add(TestHelper.trimTuple((Tuple)resAct.result));
        }
        int numExpTuples = -1;
        DataBag bagExp = DefaultBagFactory.getInstance().newDefaultBag();
        Result resExp = null;
        while (true) {
            resExp = ldExp.getNext(t);
            if (resExp.returnStatus == 3) break;
            ++numExpTuples;
            bagExp.add(TestHelper.trimTuple((Tuple)resExp.result));
        }
        if (numActTuples != numExpTuples) {
            return false;
        }
        return TestHelper.compareBags(bagExp, bagAct);
    }

    private static Tuple trimTuple(Tuple t) {
        Tuple ret = TupleFactory.getInstance().newTuple();
        for (Object o : t.getAll()) {
            DataByteArray dba = (DataByteArray)o;
            DataByteArray nDba = new DataByteArray(dba.toString().trim().getBytes());
            ret.append((Object)nDba);
        }
        return ret;
    }

    public static File createTempFile(String[][] data) throws IOException {
        File fp1 = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(fp1));
        for (int i = 0; i < data.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < data[0].length; ++j) {
                if (j != 0) {
                    sb.append("\t");
                }
                sb.append(data[i][j]);
            }
            ps.println(sb.toString());
        }
        ps.close();
        return fp1;
    }

    public static boolean mapEquals(Map<String, Object> expectedMap, Map<String, Object> convertedMap) {
        if (expectedMap == null ? convertedMap != null : convertedMap == null) {
            return false;
        }
        if (expectedMap.size() != convertedMap.size()) {
            return false;
        }
        for (String key : expectedMap.keySet()) {
            Object v = convertedMap.get(key);
            String convertedValue = new String(((DataByteArray)v).get());
            if (expectedMap.get(key).toString().equals(convertedValue)) continue;
            return false;
        }
        return true;
    }

    public static boolean tupleEquals(Tuple expectedTuple, Tuple convertedTuple) {
        if (expectedTuple == null ? convertedTuple != null : convertedTuple == null) {
            return false;
        }
        if (expectedTuple.size() != convertedTuple.size()) {
            return false;
        }
        for (int i = 0; i < expectedTuple.size(); ++i) {
            Object c;
            Object e;
            try {
                e = expectedTuple.get(i);
                c = convertedTuple.get(i);
            }
            catch (Exception e1) {
                return false;
            }
            if (e instanceof Map) {
                Map eMap = (Map)e;
                if (c instanceof Map) {
                    Map cMap = (Map)c;
                    if (TestHelper.mapEquals(eMap, cMap)) continue;
                    return false;
                }
                return false;
            }
            if (e instanceof Tuple) {
                if (c instanceof Tuple) {
                    if (TestHelper.tupleEquals((Tuple)e, (Tuple)c)) continue;
                    return false;
                }
                return false;
            }
            if (e instanceof DataBag) {
                if (c instanceof DataBag) {
                    if (TestHelper.bagEquals((DataBag)e, (DataBag)c)) continue;
                    return false;
                }
                return false;
            }
            if (e == null) {
                if (c == null) continue;
                return false;
            }
            if (c == null) {
                return false;
            }
            if (e.equals(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean bagEquals(DataBag expectedBag, DataBag convertedBag) {
        if (expectedBag == null ? convertedBag != null : convertedBag == null) {
            return false;
        }
        if (expectedBag.size() != convertedBag.size()) {
            return false;
        }
        Iterator expectedBagIterator = expectedBag.iterator();
        Iterator convertedBagIterator = convertedBag.iterator();
        while (expectedBagIterator.hasNext()) {
            Tuple convertedBagTuple;
            Tuple expectedBagTuple = (Tuple)expectedBagIterator.next();
            if (TestHelper.tupleEquals(expectedBagTuple, convertedBagTuple = (Tuple)convertedBagIterator.next())) continue;
            return false;
        }
        return true;
    }
}

