/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.TypeGraphPrinter;

public class TypeCheckingTestUtil {
    public static LOLoad genDummyLOLoad(LogicalPlan plan) {
        String pigStorage = PigStorage.class.getName();
        try {
            LOLoad load = new LOLoad(plan, TypeCheckingTestUtil.genNewOperatorKey(), new FileSpec("pi", new FuncSpec(pigStorage)), ConfigurationUtil.toConfiguration((Properties)new Properties()));
            return load;
        }
        catch (IOException e) {
            throw new AssertionError((Object)"This cannot happen");
        }
    }

    public static Schema genFlatSchema(String[] aliases, byte[] types) {
        if (aliases.length != types.length) {
            throw new AssertionError((Object)" aliase number and type number don't match");
        }
        ArrayList<Schema.FieldSchema> fsList = new ArrayList<Schema.FieldSchema>();
        for (int i = 0; i < aliases.length; ++i) {
            fsList.add(new Schema.FieldSchema(aliases[i], types[i]));
        }
        return new Schema(fsList);
    }

    public static OperatorKey genNewOperatorKey() {
        long newId = NodeIdGenerator.getGenerator().getNextNodeId("scope");
        return new OperatorKey("scope", newId);
    }

    public static void printTypeGraph(LogicalPlan plan) {
        System.out.println("*****Type Graph*******");
        TypeGraphPrinter printer = new TypeGraphPrinter(plan);
        String rep = printer.printToString();
        System.out.println(rep);
    }

    public static void printMessageCollector(CompilationMessageCollector collector) {
        if (collector.hasMessage()) {
            System.out.println("*****MessageCollector dump*******");
            for (CompilationMessageCollector.Message msg : collector) {
                System.out.println(msg.getMessageType() + ":" + msg.getMessage());
            }
        }
    }

    public static void printCurrentMethodName() {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        boolean doNext = false;
        for (StackTraceElement s : e) {
            if (doNext) {
                System.out.println(s.getMethodName());
                return;
            }
            doNext = s.getMethodName().equals("printCurrentMethodName");
        }
    }

    public static String getCurrentMethodName() {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        boolean doNext = false;
        for (StackTraceElement s : e) {
            if (doNext) {
                return s.getMethodName();
            }
            doNext = s.getMethodName().equals("getCurrentMethodName");
        }
        return null;
    }
}

