/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.test.utils.dotGraph.NodeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactKeyMatcher
implements NodeMatcher<Operator, OperatorPlan<Operator>> {
    @Override
    public Map<OperatorKey, OperatorKey> match(OperatorPlan<Operator> plan1, OperatorPlan<Operator> plan2, StringBuilder messages) {
        int diff1 = this.diffKeys(plan1, plan2, messages, "plan2");
        int diff2 = this.diffKeys(plan2, plan1, messages, "plan1");
        if (diff1 != 0 || diff2 != 0) {
            return null;
        }
        Iterator iter = plan1.getKeys().values().iterator();
        HashMap<OperatorKey, OperatorKey> outputMap = new HashMap<OperatorKey, OperatorKey>();
        while (iter.hasNext()) {
            Operator op = (Operator)iter.next();
            outputMap.put(op.getOperatorKey(), op.getOperatorKey());
        }
        return outputMap;
    }

    private int diffKeys(OperatorPlan<Operator> plan1, OperatorPlan<Operator> plan2, StringBuilder messages, String plan2Name) {
        int count = 0;
        Map keyList = plan1.getKeys();
        for (OperatorKey key : keyList.keySet()) {
            if (plan2.getOperator(key) != null) continue;
            Operator op1 = plan1.getOperator(key);
            if (messages != null) {
                messages.append(op1.getClass().getSimpleName());
                this.appendOpKey(op1.getOperatorKey(), messages);
                messages.append(" doesn't exist");
                if (plan2Name != null) {
                    messages.append(" in ");
                    messages.append(plan2Name);
                    messages.append("\n");
                }
            }
            ++count;
        }
        return count;
    }

    protected void appendOpKey(OperatorKey operatorKey, StringBuilder sb) {
        sb.append("(");
        sb.append(operatorKey.toString());
        sb.append(")");
    }
}

