/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.dotGraph;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.parser.QueryParser;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.test.utils.dotGraph.DotNode;
import org.apache.pig.test.utils.dotGraph.OperatorPlanLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanLoader
extends OperatorPlanLoader<LogicalOperator, LogicalPlan> {
    @Override
    protected LogicalOperator createOperator(DotNode node, LogicalPlan plan) {
        String operatorType = node.attributes.get("type");
        if (operatorType == null) {
            throw new RuntimeException("Unspecified operator type from Dot file");
        }
        if (operatorType.equals("LOLoad")) {
            return this.createLOLoad(node, plan);
        }
        if (operatorType.equals("LOFilter")) {
            return this.createLOFilter(node, plan);
        }
        if (operatorType.equals("LODistinct")) {
            return this.createLODistinct(node, plan);
        }
        if (operatorType.equals("LOSort")) {
            return this.createLOSort(node, plan);
        }
        if (operatorType.equals("LOForEach")) {
            return this.createLOForEach(node, plan);
        }
        if (operatorType.equals("LOSplit")) {
            return this.createLOSplit(node, plan);
        }
        if (operatorType.equals("LOSplitOutput")) {
            return this.createLOSplitOutput(node, plan);
        }
        if (operatorType.equals("LOCogroup")) {
            return this.createLOCogroup(node, plan);
        }
        if (operatorType.equals("LOForEach")) {
            return this.createLOForEach(node, plan);
        }
        if (operatorType.equals("LOUnion")) {
            return this.createLOUnion(node, plan);
        }
        if (operatorType.equals("LOCross")) {
            return this.createLOCross(node, plan);
        }
        throw new AssertionError((Object)"Unknown operator type");
    }

    private LOLoad createLOLoad(DotNode node, LogicalPlan plan) {
        LOLoad load = null;
        FileSpec fileSpec = new FileSpec("pi", new FuncSpec(PigStorage.class.getName()));
        try {
            load = new LOLoad(plan, this.getKey(node.attributes), fileSpec, null);
            this.fillSchema((LogicalOperator)load, node.attributes);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"Dummy data is not good");
        }
        return load;
    }

    private LOFilter createLOFilter(DotNode node, LogicalPlan plan) {
        LOFilter filter = new LOFilter(plan, this.getKey(node.attributes), null);
        this.fillSchema((LogicalOperator)filter, node.attributes);
        return filter;
    }

    private LODistinct createLODistinct(DotNode node, LogicalPlan plan) {
        LODistinct distinct = new LODistinct(plan, this.getKey(node.attributes));
        this.fillSchema((LogicalOperator)distinct, node.attributes);
        return distinct;
    }

    private LOSort createLOSort(DotNode node, LogicalPlan plan) {
        LOSort sort = new LOSort(plan, this.getKey(node.attributes), null, null, null);
        this.fillSchema((LogicalOperator)sort, node.attributes);
        return sort;
    }

    private LOForEach createLOForEach(DotNode node, LogicalPlan plan) {
        LOForEach foreach = new LOForEach(plan, this.getKey(node.attributes), null, null);
        this.fillSchema((LogicalOperator)foreach, node.attributes);
        return foreach;
    }

    private LOSplit createLOSplit(DotNode node, LogicalPlan plan) {
        LOSplit split = new LOSplit(plan, this.getKey(node.attributes), null);
        this.fillSchema((LogicalOperator)split, node.attributes);
        return split;
    }

    private LOSplitOutput createLOSplitOutput(DotNode node, LogicalPlan plan) {
        LOSplitOutput splitOut = new LOSplitOutput(plan, this.getKey(node.attributes), 0, null);
        this.fillSchema((LogicalOperator)splitOut, node.attributes);
        return splitOut;
    }

    private LOCogroup createLOCogroup(DotNode node, LogicalPlan plan) {
        LOCogroup cogroup = new LOCogroup(plan, this.getKey(node.attributes), null, null);
        this.fillSchema((LogicalOperator)cogroup, node.attributes);
        return cogroup;
    }

    private LOUnion createLOUnion(DotNode node, LogicalPlan plan) {
        LOUnion union = new LOUnion(plan, this.getKey(node.attributes));
        this.fillSchema((LogicalOperator)union, node.attributes);
        return union;
    }

    private LOCross createLOCross(DotNode node, LogicalPlan plan) {
        LOCross cross = new LOCross(plan, this.getKey(node.attributes));
        this.fillSchema((LogicalOperator)cross, node.attributes);
        return cross;
    }

    private void fillSchema(LogicalOperator op, Map<String, String> attributes) {
        String schemaString = attributes.get("schema");
        if (schemaString != null) {
            int dummyAliasCounter = 0;
            String DUMMY_ALIAS_PREFIX = "MY_DUMMY_ALIAS_";
            while (schemaString.indexOf("[NoAlias]") != -1) {
                schemaString = schemaString.replaceFirst("\\[NoAlias\\]", DUMMY_ALIAS_PREFIX + dummyAliasCounter++);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(schemaString.getBytes());
            QueryParser queryParser = new QueryParser((InputStream)stream);
            Schema schema = null;
            try {
                schema = queryParser.TupleSchema();
                Schema.setSchemaDefaultType((Schema)schema, (byte)50);
                for (int i = 0; i < dummyAliasCounter; ++i) {
                    this.replaceAliasByNull(schema, DUMMY_ALIAS_PREFIX + i);
                }
                op.forceSchema(schema);
                op.setSchemaComputed(true);
            }
            catch (ParseException pe) {
                System.out.println(pe.getMessage());
                throw new RuntimeException("Error reading schema string");
            }
        } else {
            op.forceSchema(null);
        }
    }

    private boolean replaceAliasByNull(Schema schema, String alias) {
        if (schema != null) {
            for (int i = 0; i < schema.size(); ++i) {
                try {
                    if (schema.getField((int)i).alias != null && schema.getField((int)i).alias.equals(alias)) {
                        schema.getField((int)i).alias = null;
                        return true;
                    }
                    if (schema.getField((int)i).type != 120 && schema.getField((int)i).type != 110 || !this.replaceAliasByNull(schema.getField((int)i).schema, alias)) continue;
                    return true;
                }
                catch (FrontendException e) {
                    throw new AssertionError((Object)"Cannot access schema internals");
                }
            }
        }
        return false;
    }
}

