/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.utils.planComparer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.test.utils.dotGraph.IncreasingKeyMatcher;
import org.apache.pig.test.utils.dotGraph.NodeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanStructuralComparer<E extends Operator, P extends OperatorPlan<E>> {
    protected Map<OperatorKey, OperatorKey> plan1ToPlan2 = null;
    protected Map<OperatorKey, OperatorKey> plan2ToPlan1 = null;
    private NodeMatcher nodeMatcher = new IncreasingKeyMatcher();

    public boolean structurallyEquals(P plan1, P plan2, StringBuilder messages) {
        this.plan1ToPlan2 = this.nodeMatcher.match(plan1, plan2, messages);
        if (this.plan1ToPlan2 == null) {
            return false;
        }
        this.plan2ToPlan1 = this.generateInverseMap(this.plan1ToPlan2);
        int diffCount = 0;
        for (OperatorKey opKey : plan1.getKeys().keySet()) {
            Operator op1 = plan1.getOperator(opKey);
            Operator op2 = plan2.getOperator(this.plan1ToPlan2.get(opKey));
            diffCount += this.diffOutgoingEdges(op1, op2, plan1, plan2, messages, "plan1", "plan2");
        }
        return diffCount == 0;
    }

    public boolean structurallyEquals(P plan1, P plan2) {
        return this.structurallyEquals(plan1, plan2, null);
    }

    public void setNodeMatcher(NodeMatcher matcher) {
        this.nodeMatcher = matcher;
    }

    private Map<OperatorKey, OperatorKey> generateInverseMap(Map<OperatorKey, OperatorKey> map) {
        HashMap<OperatorKey, OperatorKey> inverseMap = new HashMap<OperatorKey, OperatorKey>();
        for (OperatorKey key : map.keySet()) {
            inverseMap.put(map.get(key), key);
        }
        return inverseMap;
    }

    private int diffOutgoingEdges(E operator1, E operator2, P plan1, P plan2, StringBuilder messages, String plan1Name, String plan2Name) {
        int diffCount = 0;
        List list1 = plan1.getSuccessors(operator1);
        List list2 = plan2.getSuccessors(operator2);
        if (list1 == null && list2 == null) {
            return 0;
        }
        if (list1 != null && list2 == null) {
            for (Operator op : list1) {
                if (messages != null) {
                    this.appendMissingEdgeMessage(operator1.getOperatorKey(), op.getOperatorKey(), messages, plan2Name);
                }
                ++diffCount;
            }
            return diffCount;
        }
        if (list1 == null && list2 != null) {
            for (Operator op : list2) {
                if (messages != null) {
                    this.appendMissingEdgeMessage(operator2.getOperatorKey(), op.getOperatorKey(), messages, plan1Name);
                }
                ++diffCount;
            }
            return diffCount;
        }
        HashMap<OperatorKey, Boolean> edgeMap2 = new HashMap<OperatorKey, Boolean>();
        for (Operator op : list2) {
            edgeMap2.put(op.getOperatorKey(), true);
        }
        for (Operator op : list1) {
            if (edgeMap2.get(this.plan1ToPlan2.get(op.getOperatorKey())) != null) continue;
            if (messages != null) {
                this.appendMissingEdgeMessage(operator1.getOperatorKey(), op.getOperatorKey(), messages, plan2Name);
            }
            ++diffCount;
        }
        HashMap<OperatorKey, Boolean> edgeMap1 = new HashMap<OperatorKey, Boolean>();
        for (Operator op : list1) {
            edgeMap1.put(op.getOperatorKey(), true);
        }
        for (Operator op : list2) {
            if (edgeMap1.get(this.plan2ToPlan1.get(op.getOperatorKey())) != null) continue;
            if (messages != null) {
                this.appendMissingEdgeMessage(operator2.getOperatorKey(), op.getOperatorKey(), messages, plan1Name);
            }
            ++diffCount;
        }
        return diffCount;
    }

    protected void appendOpKey(OperatorKey operatorKey, StringBuilder sb) {
        sb.append("(");
        sb.append(operatorKey.toString());
        sb.append(")");
    }

    private void appendMissingEdgeMessage(OperatorKey fromKey, OperatorKey toKey, StringBuilder messages, String planName) {
        messages.append("Edge ");
        this.appendOpKey(fromKey, messages);
        messages.append(" -> ");
        this.appendOpKey(toKey, messages);
        messages.append(" doesn't exist");
        if (planName != null) {
            messages.append(" in ");
            messages.append(planName);
        }
        messages.append("\n");
    }
}

