/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.server;

import com.facebook.thrift.TException;
import com.facebook.thrift.TProcessor;
import com.facebook.thrift.TProcessorFactory;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.server.TServer;
import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.transport.TTransportFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TThreadPoolServer
extends TServer {
    private ExecutorService executorService_ = null;

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport) {
        this(tProcessor, tServerTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), new Options());
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport) {
        this(tProcessorFactory, tServerTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), new Options());
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TProtocolFactory tProtocolFactory) {
        this(tProcessor, tServerTransport, new TTransportFactory(), new TTransportFactory(), tProtocolFactory, tProtocolFactory, new Options());
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TProtocolFactory tProtocolFactory) {
        this(tProcessor, tServerTransport, tTransportFactory, tTransportFactory, tProtocolFactory, tProtocolFactory, new Options());
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TProtocolFactory tProtocolFactory) {
        this(tProcessorFactory, tServerTransport, tTransportFactory, tTransportFactory, tProtocolFactory, tProtocolFactory, new Options());
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2, Options options) {
        this(new TProcessorFactory(tProcessor), tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2, options);
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2, Options options) {
        super(tProcessorFactory, tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2);
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        this.executorService_ = new ThreadPoolExecutor(options.minWorkerThreads, options.maxWorkerThreads, 60L, TimeUnit.SECONDS, linkedBlockingQueue);
    }

    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException tTransportException) {
            tTransportException.printStackTrace();
            return;
        }
        while (true) {
            int n = 0;
            try {
                TTransport tTransport = this.serverTransport_.accept();
                WorkerProcess workerProcess = new WorkerProcess(tTransport);
                this.executorService_.execute(workerProcess);
                continue;
            }
            catch (TTransportException tTransportException) {
                ++n;
                tTransportException.printStackTrace();
                continue;
            }
            break;
        }
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport tTransport) {
            this.client_ = tTransport;
        }

        public void run() {
            TProcessor tProcessor = null;
            TTransport tTransport = null;
            TTransport tTransport2 = null;
            TProtocol tProtocol = null;
            TProtocol tProtocol2 = null;
            try {
                tProcessor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                tTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                tTransport2 = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                tProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(tTransport);
                tProtocol2 = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(tTransport2);
                while (tProcessor.process(tProtocol, tProtocol2)) {
                }
            }
            catch (TTransportException tTransportException) {
            }
            catch (TException tException) {
                tException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (tTransport != null) {
                tTransport.close();
            }
            if (tTransport2 != null) {
                tTransport2.close();
            }
        }
    }

    public static class Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
    }
}

