/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class TFramedTransport
extends TTransport {
    private TTransport transport_ = null;
    private final MyByteArrayOutputStream writeBuffer_ = new MyByteArrayOutputStream(1024);
    private ByteArrayInputStream readBuffer_ = null;
    private boolean frameRead_ = true;
    private boolean frameWrite_ = true;

    public TFramedTransport(TTransport tTransport) {
        this(tTransport, true, true);
    }

    public TFramedTransport(TTransport tTransport, boolean bl, boolean bl2) {
        this.transport_ = tTransport;
        this.frameRead_ = bl;
        this.frameWrite_ = bl2;
    }

    public void setFrameRead(boolean bl) {
        this.frameRead_ = bl;
    }

    public void setFrameWrite(boolean bl) {
        this.frameWrite_ = bl;
    }

    public void open() throws TTransportException {
        this.transport_.open();
    }

    public boolean isOpen() {
        return this.transport_.isOpen();
    }

    public void close() {
        this.transport_.close();
    }

    public int read(byte[] byArray, int n, int n2) throws TTransportException {
        int n3;
        if (!this.frameRead_) {
            return this.transport_.read(byArray, n, n2);
        }
        if (this.readBuffer_ != null && (n3 = this.readBuffer_.read(byArray, n, n2)) > 0) {
            return n3;
        }
        this.readFrame();
        return this.readBuffer_.read(byArray, n, n2);
    }

    private void readFrame() throws TTransportException {
        byte[] byArray = new byte[4];
        this.transport_.readAll(byArray, 0, 4);
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        byte[] byArray2 = new byte[n];
        this.transport_.readAll(byArray2, 0, n);
        this.readBuffer_ = new ByteArrayInputStream(byArray2);
    }

    public void write(byte[] byArray, int n, int n2) throws TTransportException {
        if (!this.frameWrite_) {
            this.transport_.write(byArray, n, n2);
            return;
        }
        this.writeBuffer_.write(byArray, n, n2);
    }

    public void flush() throws TTransportException {
        if (!this.frameWrite_) {
            this.transport_.flush();
            return;
        }
        byte[] byArray = this.writeBuffer_.get();
        int n = this.writeBuffer_.len();
        this.writeBuffer_.reset();
        byte[] byArray2 = new byte[]{(byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
        this.transport_.write(byArray2, 0, 4);
        this.transport_.write(byArray, 0, n);
        this.transport_.flush();
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int n) {
            super(n);
        }

        public byte[] get() {
            return this.buf;
        }

        public int len() {
            return this.count;
        }
    }
}

