/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TIOStreamTransport
extends TTransport {
    protected InputStream inputStream_ = null;
    protected OutputStream outputStream_ = null;

    protected TIOStreamTransport() {
    }

    public TIOStreamTransport(InputStream inputStream) {
        this.inputStream_ = inputStream;
    }

    public TIOStreamTransport(OutputStream outputStream) {
        this.outputStream_ = outputStream;
    }

    public TIOStreamTransport(InputStream inputStream, OutputStream outputStream) {
        this.inputStream_ = inputStream;
        this.outputStream_ = outputStream;
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public void close() {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Error closing input stream: " + iOException.getMessage());
            }
            this.inputStream_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Error closing output stream: " + iOException.getMessage());
            }
            this.outputStream_ = null;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException(1, "Cannot read from null inputStream");
        }
        try {
            return this.inputStream_.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new TTransportException(0, (Throwable)iOException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot write to null outputStream");
        }
        try {
            this.outputStream_.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new TTransportException(0, (Throwable)iOException);
        }
    }

    public void flush() throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot flush null outputStream");
        }
        try {
            this.outputStream_.flush();
        }
        catch (IOException iOException) {
            throw new TTransportException(0, (Throwable)iOException);
        }
    }
}

