/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceMetadata;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoUtilTest {
    private Random rnd;
    TaskID[] tasks;

    @Before
    public void setUp() throws Exception {
        this.rnd = new Random();
        this.tasks = new TaskID[4];
        this.tasks[0] = new TaskID(4);
        this.tasks[1] = new TaskID(8);
        this.tasks[2] = new TaskID(12);
        this.tasks[3] = new TaskID(20);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLong() {
        int NUM_TESTS = 100000;
        for (int i = 0; i < 100000; ++i) {
            long l = this.rnd.nextLong();
            Assert.assertEquals(l, IoUtil.hexStringToLong(IoUtil.longToString(l)));
        }
        Assert.assertEquals(Long.MAX_VALUE, IoUtil.hexStringToLong(IoUtil.longToString(Long.MAX_VALUE)));
        Assert.assertEquals(Long.MIN_VALUE, IoUtil.hexStringToLong(IoUtil.longToString(Long.MIN_VALUE)));
        Assert.assertEquals(0L, IoUtil.hexStringToLong(IoUtil.longToString(0L)));
    }

    @Test
    public void testFastOpIdExtraction() {
        XTraceMetadata md = new XTraceMetadata(new TaskID(4), 0);
        Assert.assertEquals("00000000", IoUtil.fastOpIdExtraction(md.toString()));
        md = new XTraceMetadata(new TaskID(4), 0L);
        Assert.assertEquals("0000000000000000", IoUtil.fastOpIdExtraction(md.toString()));
        md = new XTraceMetadata(new TaskID(12), 0);
        Assert.assertEquals("00000000", IoUtil.fastOpIdExtraction(md.toString()));
        md = new XTraceMetadata(new TaskID(12), 0L);
        Assert.assertEquals("0000000000000000", IoUtil.fastOpIdExtraction(md.toString()));
        int NUM_TESTS = 10000;
        for (int i = 0; i < 10000; ++i) {
            md = this.rnd.nextBoolean() ? new XTraceMetadata(this.tasks[this.rnd.nextInt(4)], this.rnd.nextInt()) : new XTraceMetadata(this.tasks[this.rnd.nextInt(4)], this.rnd.nextLong());
            Assert.assertEquals(md.getOpIdString(), IoUtil.fastOpIdExtraction(md.toString()));
        }
    }

    @Test
    public void opidExtractionPerformance() {
        int NUM_TESTS = 100000;
        String[] md = new String[100000];
        for (int i = 0; i < 100000; ++i) {
            md[i] = this.rnd.nextBoolean() ? new XTraceMetadata(this.tasks[this.rnd.nextInt(4)], this.rnd.nextInt()).toString() : new XTraceMetadata(this.tasks[this.rnd.nextInt(4)], this.rnd.nextLong()).toString();
        }
        long startStandard = System.currentTimeMillis();
        for (int i = 0; i < md.length; ++i) {
            XTraceMetadata mdobj = XTraceMetadata.createFromString(md[i]);
            String opidstr = mdobj.getOpIdString();
        }
        long endStandard = System.currentTimeMillis();
        long startFast = System.currentTimeMillis();
        for (int i = 0; i < md.length; ++i) {
            String opidstr = IoUtil.fastOpIdExtraction(md[i]);
        }
        long endFast = System.currentTimeMillis();
        System.out.println("Standard completed in " + (endStandard - startStandard) + " ms");
        System.out.println("Fast completed in " + (endFast - startFast) + " ms");
    }
}

