/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class OptionField {
    public static final byte NOP = 0;
    public static final byte SEVERITY = -50;
    private static final Logger LOG = Logger.getLogger(OptionField.class);
    private final byte type;
    private final byte[] payload;

    private OptionField() {
        this.type = 0;
        this.payload = null;
    }

    private OptionField(byte type, byte[] payloadbytes, int payloadoffset, int payloadlength) {
        if (payloadlength > 256) {
            LOG.warn("Option payloads cannot exceed 256 bytes");
            this.type = 0;
            this.payload = null;
        } else {
            this.type = type;
            if (payloadbytes != null && payloadlength > 0) {
                this.payload = new byte[payloadlength];
                System.arraycopy(payloadbytes, payloadoffset, this.payload, 0, payloadlength);
            } else {
                this.payload = null;
            }
        }
    }

    public OptionField(byte type, byte[] payload) {
        this.type = type;
        if (payload != null) {
            this.payload = new byte[payload.length];
            System.arraycopy(payload, 0, this.payload, 0, payload.length);
        } else {
            this.payload = null;
        }
    }

    public static OptionField createFromBytes(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            LOG.warn("'bytes' cannot be null");
            return new OptionField();
        }
        if (bytes.length - offset < length) {
            LOG.warn("'length' field too large for the bytes provided");
            return new OptionField();
        }
        if (length > 258) {
            LOG.warn("Length of Option payload cannot exceed 256 bytes");
            return new OptionField();
        }
        return new OptionField(bytes[offset - 2], bytes, offset, length);
    }

    public static OptionField createFromString(String s) {
        byte[] bytes = null;
        try {
            bytes = IoUtil.stringToBytes(s);
        }
        catch (IOException e) {
            LOG.warn("Invalid String: " + s);
            return new OptionField();
        }
        return OptionField.createFromBytes(bytes, 0, bytes.length);
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] pack() {
        if (this.payload == null) {
            byte[] ret = new byte[]{this.type, 2};
            return ret;
        }
        byte[] buf = new byte[this.payload.length + 2];
        buf[0] = this.type;
        buf[1] = (byte)this.payload.length;
        System.arraycopy(this.payload, 0, buf, 2, this.payload.length);
        return buf;
    }

    public String toString() {
        try {
            return IoUtil.bytesToString(this.pack());
        }
        catch (IOException e) {
            LOG.warn("Internal I/O error");
            return "0002";
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionField other = (OptionField)obj;
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        return this.type == other.type;
    }
}

