/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.IoUtil;
import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceEvent;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.XTraceProcess;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class XTraceContext {
    private static ThreadLocal<XTraceMetadata> context = new ThreadLocal<XTraceMetadata>(){

        @Override
        protected XTraceMetadata initialValue() {
            return null;
        }
    };
    private static String hostname = null;
    static int defaultOpIdLength = 8;

    public static synchronized void setThreadContext(XTraceMetadata ctx) {
        if (ctx != null && ctx.isValid()) {
            context.set(ctx);
        } else {
            context.set(null);
        }
    }

    public static synchronized XTraceMetadata getThreadContext() {
        return context.get();
    }

    public static synchronized void clearThreadContext() {
        context.set(null);
    }

    public static void logEvent(String agent, String label) {
        if (!XTraceContext.isValid()) {
            return;
        }
        XTraceContext.createEvent(agent, label).sendReport();
    }

    public static void logEvent(String agent, String label, Object ... args) {
        if (!XTraceContext.isValid()) {
            return;
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("XTraceContext.logEvent requires an even number of arguments.");
        }
        XTraceEvent event = XTraceContext.createEvent(agent, label);
        for (int i = 0; i < args.length / 2; ++i) {
            String key = args[2 * i].toString();
            String value = args[2 * i + 1].toString();
            event.put(key, value);
        }
        event.sendReport();
    }

    public static XTraceEvent createEvent(String agent, String label) {
        if (!XTraceContext.isValid()) {
            return null;
        }
        XTraceMetadata oldContext = XTraceContext.getThreadContext();
        int opIdLength = defaultOpIdLength;
        if (oldContext != null) {
            opIdLength = oldContext.getOpIdLength();
        }
        XTraceEvent event = new XTraceEvent(opIdLength);
        event.addEdge(oldContext);
        try {
            if (hostname == null) {
                hostname = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
        event.put("Host", hostname);
        event.put("Agent", agent);
        event.put("Label", label);
        XTraceContext.setThreadContext(event.getNewMetadata());
        return event;
    }

    public static boolean isValid() {
        return XTraceContext.getThreadContext() != null;
    }

    public static XTraceProcess startProcess(String agent, String process, Object ... args) {
        XTraceContext.logEvent(agent, process + " start", args);
        return new XTraceProcess(XTraceContext.getThreadContext(), agent, process);
    }

    public static void endProcess(XTraceProcess process) {
        XTraceContext.endProcess(process, process.name + " end");
    }

    public static void endProcess(XTraceProcess process, String label) {
        if (XTraceContext.getThreadContext() != null) {
            XTraceMetadata oldContext = XTraceContext.getThreadContext();
            XTraceEvent evt = XTraceContext.createEvent(process.agent, label);
            if (oldContext != process.startCtx) {
                evt.addEdge(process.startCtx);
            }
            evt.sendReport();
        }
    }

    public static void failProcess(XTraceProcess process, Throwable exception) {
        if (XTraceContext.getThreadContext() != null) {
            XTraceMetadata oldContext = XTraceContext.getThreadContext();
            XTraceEvent evt = XTraceContext.createEvent(process.agent, process.name + " failed");
            if (oldContext != process.startCtx) {
                evt.addEdge(process.startCtx);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            pw.flush();
            evt.put("Exception", IoUtil.escapeNewlines(sw.toString()));
            evt.sendReport();
        }
    }

    public static void failProcess(XTraceProcess process, String reason) {
        if (XTraceContext.getThreadContext() != null) {
            XTraceMetadata oldContext = XTraceContext.getThreadContext();
            XTraceEvent evt = XTraceContext.createEvent(process.agent, process.name + " failed");
            if (oldContext != process.startCtx) {
                evt.addEdge(process.startCtx);
            }
            evt.put("Reason", reason);
            evt.sendReport();
        }
    }

    public static void startTrace(String agent, String title, String ... tags) {
        TaskID taskId = new TaskID(8);
        XTraceContext.setThreadContext(new XTraceMetadata(taskId, 0L));
        XTraceEvent event = XTraceContext.createEvent(agent, "Start Trace: " + title);
        event.put("Title", title);
        for (String tag : tags) {
            event.put("Tag", tag);
        }
        event.sendReport();
    }

    public static void startTraceSeverity(String agent, String title, int severity, String ... tags) {
        TaskID taskId = new TaskID(8);
        XTraceContext.setThreadContext(new XTraceMetadata(taskId, 0L));
        XTraceContext.getThreadContext().setSeverity(severity);
        XTraceEvent event = XTraceContext.createEvent(agent, "Start Trace: " + title);
        event.put("Title", title);
        for (String tag : tags) {
            event.put("Tag", tag);
        }
        event.sendReport();
    }

    public static int getDefaultOpIdLength() {
        return defaultOpIdLength;
    }

    public static void setDefaultOpIdLength(int defaultOpIdLength) {
        XTraceContext.defaultOpIdLength = defaultOpIdLength;
    }

    public static void writeThreadContext(DataOutput out) throws IOException {
        XTraceMetadata.write(XTraceContext.getThreadContext(), out);
    }

    public static void readThreadContext(DataInput in) throws IOException {
        XTraceContext.setThreadContext(XTraceMetadata.read(in));
    }

    public static synchronized XTraceMetadata switchThreadContext(XTraceMetadata newContext) {
        XTraceMetadata oldContext = XTraceContext.getThreadContext();
        XTraceContext.setThreadContext(newContext);
        return oldContext;
    }
}

