/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace;

import edu.berkeley.xtrace.OptionField;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public class XTraceEvent {
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            int processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            try {
                return new Random(++threadId + (long)processId + System.nanoTime() + Thread.currentThread().getId() + (long)InetAddress.getLocalHost().getHostName().hashCode());
            }
            catch (UnknownHostException e) {
                return new Random(++threadId + (long)processId + System.nanoTime() + Thread.currentThread().getId());
            }
        }
    };
    private static volatile long threadId = 0L;
    private Report report = new Report();
    private byte[] myOpId;
    private boolean willReport;

    public XTraceEvent(int opIdLength) {
        this.myOpId = new byte[opIdLength];
        random.get().nextBytes(this.myOpId);
        this.willReport = true;
    }

    public void addEdge(XTraceMetadata xtr) {
        if (xtr == null || !xtr.isValid()) {
            return;
        }
        OptionField[] options = xtr.getOptions();
        if (options != null) {
            for (int i = 0; i < xtr.getNumOptions(); ++i) {
                if (options[i].getType() - -50 != 0) continue;
                int severity = options[i].getPayload()[0] & 0xFF;
                this.willReport = severity < 5;
                this.report.put("Severity", severity + "");
            }
        }
        XTraceMetadata newmd = new XTraceMetadata(xtr);
        newmd.setOpId(this.myOpId);
        this.report.put("X-Trace", newmd.toString(), false);
        this.report.put("Edge", xtr.getOpIdString());
    }

    public void put(String key, String value) {
        this.report.put(key, value);
    }

    public XTraceMetadata getNewMetadata() {
        XTraceMetadata xtr = this.report.getMetadata();
        if (xtr == null) {
            return new XTraceMetadata();
        }
        XTraceMetadata xtr2 = new XTraceMetadata(xtr);
        xtr2.setOpId(this.myOpId);
        return xtr2;
    }

    public void setMetadata(XTraceMetadata xtr) {
        this.myOpId = xtr.getOpId();
        this.report.put("X-Trace", xtr.toString(), false);
    }

    private void setTimestamp() {
        long time = System.currentTimeMillis();
        String value = String.format("%d.%03d", time / 1000L, time % 1000L);
        this.report.put("Timestamp", value, false);
    }

    public Report createReport() {
        this.setTimestamp();
        return this.report;
    }

    public void sendReport() {
        this.setTimestamp();
        if (!this.willReport) {
            return;
        }
        Reporter.getReporter().sendReport(this.report);
    }
}

