/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ReportTest {
    @Test
    public void testReport() {
        Report r = new Report();
        Assert.assertNotNull(r.toString());
        Assert.assertEquals("X-Trace Report ver 1.0\n", r.toString());
    }

    @Test
    public void testReport2() {
        Report r = new Report();
        r.put("Key1", "Value1");
        r.put("Key2", "Value2");
        List<String> kset = r.get("Key1");
        Assert.assertEquals(kset.size(), 1L);
        Assert.assertTrue(kset.contains("Value1"));
        kset = r.get("Key2");
        Assert.assertEquals(kset.size(), 1L);
        Assert.assertTrue(kset.contains("Value2"));
        kset = r.get("Key3");
        Assert.assertNull(kset);
        r.put("Key4", "Value4.1");
        r.put("Key4", "Value4.2");
        r.put("Key4", "Value4.3");
        kset = r.get("Key4");
        Assert.assertNotNull(kset);
        Assert.assertEquals(kset.size(), 3L);
        Assert.assertTrue(kset.contains("Value4.1"));
        Assert.assertTrue(kset.contains("Value4.2"));
        Assert.assertTrue(kset.contains("Value4.3"));
    }

    @Test
    public void testRemove() {
        Report r = new Report();
        r.put("Key1", "Value1");
        r.put("Key2", "Value2");
        List<String> kset = r.get("Key1");
        Assert.assertEquals(kset.size(), 1L);
        Assert.assertTrue(kset.contains("Value1"));
        r.remove("Key1");
        kset = r.get("Key1");
        Assert.assertNull(kset);
        r.remove("Key2");
        kset = r.get("Key2");
        Assert.assertNull(kset);
        r.put("Key4", "Value4.1");
        r.put("Key4", "Value4.2");
        r.put("Key4", "Value4.3");
        kset = r.get("Key4");
        Assert.assertNotNull(kset);
        Assert.assertEquals(kset.size(), 3L);
        Assert.assertTrue(kset.contains("Value4.1"));
        Assert.assertTrue(kset.contains("Value4.2"));
        Assert.assertTrue(kset.contains("Value4.3"));
        r.remove("Key4");
        kset = r.get("Key4");
        Assert.assertNull(kset);
    }

    @Test
    public void testGetMetadata() {
        TaskID task = new TaskID(8);
        XTraceMetadata md = new XTraceMetadata(task, 0);
        Report r = new Report();
        r.put("X-Trace", md.toString());
        r.put("Key1", "Value1");
        r.put("Key2", "Value2");
        Assert.assertEquals(md, r.getMetadata());
        r = new Report();
        r.put("Key1", "Value1");
        r.put("X-Trace", md.toString());
        r.put("Key2", "Value2");
        Assert.assertEquals(md, r.getMetadata());
    }

    @Test
    public void testToString() {
        Report r = new Report();
        XTraceMetadata xtr = new XTraceMetadata();
        r.put("X-Trace", xtr.toString());
        r.put("Key1", "Value1");
        r.put("Key2", "Value2");
        r.put("Key4", "Value4.1");
        r.put("Key4", "Value4.2");
        r.put("Key4", "Value4.3");
        String s = r.toString();
        Assert.assertNotNull(s);
        Assert.assertTrue(s.startsWith("X-Trace Report ver 1.0"));
        Assert.assertTrue(s.contains("Key1: Value1"));
        Assert.assertTrue(s.contains("Key2: Value2"));
        Assert.assertTrue(s.contains("Key4: Value4.1"));
        Assert.assertTrue(s.contains("Key4: Value4.2"));
        Assert.assertTrue(s.contains("Key4: Value4.3"));
        Assert.assertTrue(s.contains("X-Trace: 100000000000000000"));
    }

    @Test
    public void testCreateFromString() {
        Report r = new Report();
        r.put("Key1", "Value1");
        r.put("Key2", "Value2");
        r.put("Key4", "Value4.1");
        r.put("Key4", "Value4.2");
        r.put("Key4", "Value4.3");
        r.put("X-Trace", "100000000000000000");
        Report r2 = Report.createFromString(r.toString());
        String s = r2.toString();
        Assert.assertNotNull(s);
        Assert.assertTrue(s.startsWith("X-Trace Report ver 1.0"));
        Assert.assertTrue(s.contains("Key1: Value1"));
        Assert.assertTrue(s.contains("Key2: Value2"));
        Assert.assertTrue(s.contains("Key4: Value4.1"));
        Assert.assertTrue(s.contains("Key4: Value4.2"));
        Assert.assertTrue(s.contains("Key4: Value4.3"));
        Assert.assertTrue(s.contains("X-Trace: 100000000000000000"));
        r = Report.createFromString("X-Trace Report ver 1.0\nX-Trace: 0000000000\nKey1: Value1\nKey2: Value2\nKey4: Value4.1\nKey4: Value4.2\nKey4: Value4.3");
        List<String> kset = r.get("Key1");
        Assert.assertEquals(kset.size(), 1L);
        Assert.assertTrue(kset.contains("Value1"));
        kset = r.get("Key2");
        Assert.assertEquals(kset.size(), 1L);
        Assert.assertTrue(kset.contains("Value2"));
        kset = r.get("Key3");
        Assert.assertNull(kset);
        kset = r.get("Key4");
        Assert.assertEquals(kset.size(), 3L);
        Assert.assertTrue(kset.contains("Value4.1"));
        Assert.assertTrue(kset.contains("Value4.2"));
        Assert.assertTrue(kset.contains("Value4.3"));
    }
}

