/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.reporting.Report;

public abstract class Reporter {
    static Reporter reporter;

    public static final synchronized Reporter getReporter() {
        if (reporter == null) {
            String systemprop = System.getProperty("xtrace.reporter");
            if (systemprop == null) {
                systemprop = "edu.berkeley.xtrace.reporting.UdpReporter";
            }
            try {
                reporter = (Reporter)Class.forName(systemprop).newInstance();
            }
            catch (InstantiationException e) {
                System.exit(1);
            }
            catch (IllegalAccessException e) {
                System.exit(1);
            }
            catch (ClassNotFoundException e) {
                System.exit(1);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (reporter != null) {
                        reporter.close();
                    }
                }
            });
        }
        return reporter;
    }

    public abstract void sendReport(Report var1);

    public abstract void close();

    public void flush() {
    }
}

