/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public final class SendReportTool {
    private static final Logger LOG = Logger.getLogger(SendReportTool.class);
    private static Random r;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        r = new Random();
        SendReportTool.out("X-Trace command line reporter");
        if (args.length == 0 || args[0].equalsIgnoreCase("--help")) {
            SendReportTool.usage();
            System.exit(1);
        } else if (args[0].equalsIgnoreCase("-file")) {
            if (args.length != 2) {
                SendReportTool.usage();
                System.exit(1);
            }
            SendReportTool.reportFile(args[1]);
        } else if (args[0].equalsIgnoreCase("-random")) {
            SendReportTool.reportRandom();
        } else {
            if (args.length % 2 != 0) {
                SendReportTool.usage();
                System.exit(1);
            }
            SendReportTool.reportArgs(args);
        }
    }

    private static void reportArgs(String[] args) {
        Reporter ctx = Reporter.getReporter();
        Report rpt = new Report();
        for (int i = 0; i < args.length; i += 2) {
            rpt.put(args[i], args[i + 1]);
        }
        LOG.info("Sending the report:\n" + rpt);
        ctx.sendReport(rpt);
        ctx.close();
    }

    private static void reportRandom() {
        Reporter ctx = Reporter.getReporter();
        Report rpt = SendReportTool.randomReport(new TaskID(8));
        rpt.put("Agent", "RandomReport");
        rpt.put("Label", "report");
        rpt.put("Tag", "rnd");
        rpt.put("Tag", "rpt");
        rpt.put("Title", "RandomReport");
        rpt.put("Host", "localhost.localdomain");
        LOG.info("Sending the report:\n" + rpt);
        ctx.sendReport(rpt);
        ctx.close();
    }

    private static void reportFile(String f) {
        int i;
        FileInputStream fin;
        Reporter ctx = Reporter.getReporter();
        try {
            fin = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Input file not found", e);
            return;
        }
        try {
            if (fin.available() <= 0) {
                LOG.info("File " + f + " is empty, skipping.");
                fin.close();
                return;
            }
        }
        catch (IOException e) {
            LOG.warn("I/O error: ", e);
            return;
        }
        StringBuilder buf = new StringBuilder();
        byte[] contents = new byte[1024];
        try {
            int len;
            while ((len = fin.read(contents)) > 0) {
                buf.append(new String(contents, 0, len));
            }
        }
        catch (IOException e) {
            LOG.warn("I/O error", e);
        }
        try {
            fin.close();
        }
        catch (IOException e) {
            LOG.warn("I/O error", e);
        }
        String strcontents = buf.toString();
        String[] reports = strcontents.split("\n\n+");
        for (i = 0; i < reports.length; ++i) {
            Report r = Report.createFromString(reports[i]);
            ctx.sendReport(r);
        }
        System.out.println("Processed " + i + " reports");
        ctx.close();
    }

    private static void usage() {
        SendReportTool.out("CmdLineReporter key1 value1 ?key2 value2? ?key3 value3? ...");
        SendReportTool.out("or CmdLineReporter -file <filename>");
        SendReportTool.out("or CmdLineReporter -random");
        SendReportTool.out("   where <filename> contains valid X-Trace reports, separated by newlines");
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private static Report randomReport(TaskID task) {
        Report report = new Report();
        int numKeys = r.nextInt(15);
        for (int i = 0; i < numKeys; ++i) {
            report.put("Key" + i, SendReportTool.randomString(10 + r.nextInt(20)));
        }
        report.put("X-Trace", new XTraceMetadata(task, r.nextInt()).toString());
        return report;
    }

    private static String randomString(int length) {
        char[] ar = new char[length];
        for (int i = 0; i < length; ++i) {
            ar[i] = (char)(97 + r.nextInt(25));
        }
        return new String(ar);
    }
}

