/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransportException;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import edu.berkeley.xtrace.reporting.XTraceReporter;
import org.apache.log4j.Logger;

public final class ThriftReporter
extends Reporter {
    private static final Logger LOG = Logger.getLogger(ThriftReporter.class);
    String host = null;
    int port = 0;
    int retryinterval;
    boolean shouldRetry = true;
    private TSocket transport;
    private XTraceReporter.Client client;

    ThriftReporter() {
        LOG.info("Creating ThriftReportingContext");
        String thriftDest = System.getProperty("xtrace.thriftdest");
        if (thriftDest == null) {
            LOG.warn("ThriftReportingContext was used, but no xtrace.thriftdest  system property has been set. X-Trace reports  will be ignored. Please specify the command line option -Dxtrace.thriftdest=host:port to provide a destination for X-Trace reports.");
            return;
        }
        String retryInterval = System.getProperty("xtrace.thrift.retryinterval", "10");
        try {
            String[] split = thriftDest.split(":");
            this.host = split[0];
            this.port = Integer.parseInt(split[1]);
            this.retryinterval = Integer.parseInt(retryInterval);
        }
        catch (Exception e) {
            LOG.warn("Invalid xtrace.thriftdest property. Expected host:port.", e);
            System.exit(1);
        }
        this.open();
    }

    private synchronized void open() {
        LOG.info("Opening Thrift connection to " + this.host + ":" + this.port);
        this.transport = new TSocket(this.host, this.port);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new XTraceReporter.Client(protocol);
        this.shouldRetry = true;
        while (this.shouldRetry) {
            try {
                this.transport.open();
                return;
            }
            catch (TTransportException e) {
                LOG.warn("Unable to connect to the backend server", e);
                LOG.warn("Will retry in " + this.retryinterval + " seconds");
                try {
                    Thread.sleep(this.retryinterval * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            LOG.info("Closing ThriftReporter");
            this.transport.close();
            this.client = null;
        }
        this.shouldRetry = false;
    }

    @Override
    public synchronized void flush() {
        super.flush();
        if (this.client != null) {
            try {
                this.transport.flush();
            }
            catch (TTransportException e) {
                LOG.warn("Error flushing Thrift connection...reopening", e);
                this.close();
                this.open();
            }
        }
    }

    @Override
    public synchronized void sendReport(Report r) {
        try {
            if (this.client != null) {
                String reportstr = r.toString();
                this.client.sendReport(reportstr);
            }
        }
        catch (TException e) {
            LOG.warn("Unable to send report...reopening", e);
            this.close();
            this.open();
        }
    }
}

