/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.reporting;

import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.reporting.Reporter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public final class UdpReporter
extends Reporter {
    private DatagramSocket localSock;
    private InetAddress localAddr;
    private int localPort;

    UdpReporter() {
        try {
            this.localSock = new DatagramSocket();
        }
        catch (SocketException se) {
            this.localSock = null;
            return;
        }
        String udp_ip = "127.0.0.1";
        String udp_port = "7831";
        String udpDest = System.getProperty("xtrace.udpdest");
        if (udpDest != null) {
            try {
                String[] split = udpDest.split(":");
                udp_ip = split[0];
                udp_port = split[1];
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        try {
            this.localAddr = InetAddress.getByName(udp_ip);
        }
        catch (UnknownHostException uhe) {
            System.exit(1);
        }
        try {
            this.localPort = Integer.parseInt(udp_port);
        }
        catch (NumberFormatException nfe) {
            System.exit(1);
        }
    }

    @Override
    public synchronized void close() {
        if (reporter != null) {
            this.localSock.close();
            reporter = null;
        }
    }

    @Override
    public synchronized void sendReport(Report r) {
        byte[] msg;
        if (this.localSock == null) {
            return;
        }
        try {
            msg = r.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            msg = r.toString().getBytes();
        }
        DatagramPacket pkt = new DatagramPacket(msg, 0, msg.length, this.localAddr, this.localPort);
        try {
            this.localSock.send(pkt);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

