/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.server.ReportSource;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public final class DummyReportSource
implements ReportSource {
    private static final Logger LOG = Logger.getLogger(DummyReportSource.class);
    private int reportsPerSecond;
    private int reportsPerTask;
    private AtomicReference<TaskID[]> taskList = new AtomicReference();
    private BlockingQueue<String> q;
    private Timer updaterTask;
    private ReportGenerator generator;

    public DummyReportSource() {
        this.taskList.set(new TaskID[0]);
        this.updaterTask = new Timer("TaskUpdater");
    }

    @Override
    public void initialize() throws XTraceException {
        TaskListUpdater updater = new TaskListUpdater();
        this.updaterTask.scheduleAtFixedRate((TimerTask)updater, 0L, 1000L);
        String pps = System.getProperty("xtrace.dummyreportsource.packetspersecond");
        this.reportsPerSecond = pps == null ? 1 : Integer.parseInt(pps);
        String rpt = System.getProperty("xtrace.dummyreportsource.reportspertask");
        this.reportsPerTask = rpt == null ? 1 : Integer.parseInt(rpt);
        this.generator = new ReportGenerator();
        this.generator.start();
    }

    @Override
    public void setReportQueue(BlockingQueue<String> q) {
        this.q = q;
    }

    @Override
    public void shutdown() {
        this.updaterTask.cancel();
    }

    @Override
    public void run() {
    }

    private final class ReportGenerator
    extends Thread {
        private Random rnd = new Random();

        @Override
        public void run() {
            LOG.info("ReportGenerator starting");
            long interReqDelay = 1000000000L / (long)DummyReportSource.this.reportsPerSecond;
            while (true) {
                try {
                    Thread.sleep(interReqDelay / 1000000L, (int)(interReqDelay % 1000L));
                }
                catch (InterruptedException e) {
                    LOG.warn("ReportGenerator interrupted");
                }
                this.sendReport();
            }
        }

        private void sendReport() {
            TaskID id = ((TaskID[])DummyReportSource.this.taskList.get())[this.rnd.nextInt(((TaskID[])DummyReportSource.this.taskList.get()).length)];
            Report r = new Report();
            r.put("X-Trace", new XTraceMetadata(id, 0).toString());
            r.put("Time", new Date().toString());
            r.put("Key1", "Value1");
            r.put("Key2", "Value2");
            r.put("Key3", "Value3.1");
            r.put("Key3", "Value3.2");
            LOG.debug("Sending report");
            DummyReportSource.this.q.offer(r.toString());
        }
    }

    private final class TaskListUpdater
    extends TimerTask {
        private TaskListUpdater() {
        }

        @Override
        public void run() {
            LOG.debug("Updating tasklist");
            TaskID[] newList = new TaskID[Math.max(1, DummyReportSource.this.reportsPerSecond / DummyReportSource.this.reportsPerTask)];
            for (int i = 0; i < newList.length; ++i) {
                newList[i] = new TaskID(8);
            }
            DummyReportSource.this.taskList.set(newList);
        }
    }
}

