/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.server.FileTreeReportStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileTreeIteratorTest {
    private static final Logger LOG = Logger.getLogger(FileTreeIteratorTest.class);
    private static final int NUM_STOCHASTIC = 1000;
    private Report[] reports;
    private File reportFile;
    private Random r;

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure(new NullAppender());
        this.r = new Random();
        this.reports = new Report[1000];
        for (int i = 0; i < this.reports.length; ++i) {
            this.reports[i] = this.randomReport();
        }
        this.reportFile = File.createTempFile("xtrace", null);
        LOG.info("Creating temporary file: " + this.reportFile);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.reportFile)));
        for (int i = 0; i < this.reports.length; ++i) {
            out.println(this.reports[i].toString());
        }
        out.flush();
        out.close();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Deleting temporary file");
        this.reportFile.delete();
    }

    @Test
    public void testFileTreeIterator() {
        FileTreeReportStore.FileTreeIterator iter = new FileTreeReportStore.FileTreeIterator(this.reportFile);
        for (int i = 0; i < this.reports.length; ++i) {
            Assert.assertTrue(iter.hasNext());
            Assert.assertEquals(this.reports[i], iter.next());
        }
        Assert.assertFalse(iter.hasNext());
    }

    @Test
    public void testConcurrentFileTreeIterator() {
        int i;
        FileTreeReportStore.FileTreeIterator iter = new FileTreeReportStore.FileTreeIterator(this.reportFile);
        int midpoint = Math.round(this.reports.length / 2);
        for (int i2 = 0; i2 < midpoint; ++i2) {
            Assert.assertTrue(iter.hasNext());
            Assert.assertEquals(this.reports[i2], iter.next());
        }
        FileTreeReportStore.FileTreeIterator iter2 = new FileTreeReportStore.FileTreeIterator(this.reportFile);
        for (i = 0; i < midpoint; ++i) {
            Assert.assertTrue(iter2.hasNext());
            Assert.assertEquals(this.reports[i], iter2.next());
        }
        for (i = midpoint; i < this.reports.length; ++i) {
            Assert.assertTrue(iter.hasNext());
            Assert.assertTrue(iter2.hasNext());
            Assert.assertEquals(this.reports[i], iter.next());
            Assert.assertEquals(this.reports[i], iter2.next());
        }
        Assert.assertFalse(iter.hasNext());
        Assert.assertFalse(iter2.hasNext());
    }

    private Report randomReport() {
        Report report = new Report();
        int numKeys = this.r.nextInt(15);
        for (int i = 0; i < numKeys; ++i) {
            report.put("Key" + i, this.randomString(10 + this.r.nextInt(20)));
        }
        return report;
    }

    private String randomString(int length) {
        char[] ar = new char[length];
        for (int i = 0; i < length; ++i) {
            ar[i] = (char)(97 + this.r.nextInt(25));
        }
        return new String(ar);
    }
}

