/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.TaskID;
import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.XTraceMetadata;
import edu.berkeley.xtrace.reporting.Report;
import edu.berkeley.xtrace.server.FileTreeReportStore;
import edu.berkeley.xtrace.server.TaskRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileTreeReportStoreTest {
    private static final Logger LOG = Logger.getLogger(FileTreeReportStoreTest.class);
    private static final int NUM_STOCHASTIC_TASKS = 100;
    private static final int NUM_STOCHASTIC_REPORTS_PER_TASK = 10;
    private boolean canTest = true;
    private File testDirectory;
    private FileTreeReportStore fs;
    private Random r;

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure(new NullAppender());
        this.r = new Random();
        File tmpdir = new File("/tmp");
        if (!tmpdir.exists() || !tmpdir.canWrite()) {
            LOG.fatal("Unable to open /tmp directory.  Cannot execute these tests");
            this.canTest = false;
            return;
        }
        this.testDirectory = new File(tmpdir, "xtrace-reportstore");
        FileTreeReportStoreTest.deleteDir(this.testDirectory);
        this.testDirectory.mkdir();
        System.setProperty("xtrace.server.storedirectory", this.testDirectory.toString());
        this.fs = new FileTreeReportStore();
        this.fs.initialize();
    }

    @Test
    public void testSimpleInsertion() throws XTraceException {
        if (!this.canTest) {
            return;
        }
        long startTime = System.currentTimeMillis();
        XTraceMetadata md = new XTraceMetadata(new TaskID(8), 0);
        Report report = this.randomReport(md);
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals(1L, this.fs.numReports());
        Assert.assertEquals(1L, this.fs.numTasks());
        Assert.assertEquals(1L, this.fs.countByTaskId(md.getTaskId()));
        Iterator<Report> iter = this.fs.getReportsByTask(md.getTaskId());
        Assert.assertTrue(iter.hasNext());
        Report report2 = iter.next();
        Assert.assertNotNull(report2);
        Assert.assertEquals(report, report2);
        Assert.assertFalse(iter.hasNext());
        Iterator<TaskRecord> taskiter = this.fs.getTasksSince(startTime, 0, Integer.MAX_VALUE).iterator();
        Assert.assertTrue(taskiter.hasNext());
        Assert.assertEquals(md.getTaskId(), taskiter.next().getTaskId());
        Assert.assertFalse(taskiter.hasNext());
    }

    @Test
    public void testMultipleInsertion() throws XTraceException {
        int i;
        if (!this.canTest) {
            return;
        }
        int TOTAL_REPORTS = 1000;
        long startTime = System.currentTimeMillis();
        TaskID[] taskIds = new TaskID[100];
        Object[] taskStrs = new String[100];
        for (int i2 = 0; i2 < taskIds.length; ++i2) {
            taskIds[i2] = new TaskID(8);
            taskStrs[i2] = taskIds[i2].toString();
        }
        XTraceMetadata[] mds = new XTraceMetadata[1000];
        Report[] reports = new Report[1000];
        for (i = 0; i < taskIds.length; ++i) {
            for (int j = 0; j < 10; ++j) {
                int idx = i * 10 + j;
                mds[idx] = new XTraceMetadata(taskIds[i], this.r.nextInt());
                reports[idx] = this.randomReport(mds[idx]);
                this.fs.receiveReport(reports[idx].toString());
            }
        }
        this.fs.sync();
        Assert.assertEquals(1000L, this.fs.numReports());
        Assert.assertEquals(100L, this.fs.numTasks());
        for (i = 0; i < taskIds.length; ++i) {
            Assert.assertEquals(10L, this.fs.countByTaskId(taskIds[i]));
        }
        ArrayList<String> tasklst = new ArrayList<String>(100);
        Iterator<TaskRecord> taskiter = this.fs.getTasksSince(startTime, 0, Integer.MAX_VALUE).iterator();
        while (taskiter.hasNext()) {
            tasklst.add(taskiter.next().getTaskId().toString());
        }
        Object[] stringsSince = tasklst.toArray(new String[0]);
        Arrays.sort(taskStrs);
        Arrays.sort(stringsSince);
        Assert.assertTrue(Arrays.deepEquals(taskStrs, stringsSince));
        for (int i3 = 0; i3 < 100; ++i3) {
            Iterator<Report> iter = this.fs.getReportsByTask(taskIds[i3]);
            Assert.assertTrue(iter.hasNext());
            int j = 0;
            while (iter.hasNext()) {
                iter.next();
                ++j;
            }
            Assert.assertEquals(10L, j);
        }
    }

    @Test
    public void testLimitOffset() throws XTraceException {
        if (!this.canTest) {
            return;
        }
        int TOTAL_REPORTS = 1000;
        Report[] reports = new Report[1000];
        TaskID[] tasks = new TaskID[100];
        for (int i = 0; i < 100; ++i) {
            tasks[i] = new TaskID(8);
            for (int j = 0; j < 10; ++j) {
                int idx = i * 10 + j;
                reports[idx] = this.randomReport(new XTraceMetadata(tasks[i], this.r.nextInt()));
                if (i < 50) {
                    reports[idx].put("Tag", "small");
                    reports[idx].put("Title", "smaller");
                } else {
                    reports[idx].put("Tag", "big");
                    reports[idx].put("Title", "bigger");
                }
                reports[idx].put("Tag", "tag1");
                this.fs.receiveReport(reports[idx].toString());
            }
        }
        this.fs.sync();
        Assert.assertEquals(1000L, 1000L);
        List<TaskRecord> lst = this.fs.getTasksSince(0L, 0, Integer.MAX_VALUE);
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getTasksSince(0L, 0, 50);
        Assert.assertEquals(50L, lst.size());
        lst.addAll(this.fs.getTasksSince(0L, 50, 20));
        Assert.assertEquals(70L, lst.size());
        lst.addAll(this.fs.getTasksSince(0L, 70, 1));
        Assert.assertEquals(71L, lst.size());
        lst.addAll(this.fs.getTasksSince(0L, 71, 0));
        Assert.assertEquals(71L, lst.size());
        lst.addAll(this.fs.getTasksSince(0L, 71, 29));
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getLatestTasks(0, Integer.MAX_VALUE);
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getLatestTasks(0, 25);
        Assert.assertEquals(25L, lst.size());
        lst.addAll(this.fs.getLatestTasks(25, 5));
        Assert.assertEquals(30L, lst.size());
        lst.addAll(this.fs.getLatestTasks(30, 1));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getLatestTasks(31, 0));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getLatestTasks(31, 68));
        Assert.assertEquals(99L, lst.size());
        lst.addAll(this.fs.getLatestTasks(99, 1));
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE);
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getTasksByTag("small", 0, 25);
        Assert.assertEquals(25L, lst.size());
        lst.addAll(this.fs.getTasksByTag("small", 25, 5));
        Assert.assertEquals(30L, lst.size());
        lst.addAll(this.fs.getTasksByTag("small", 30, 1));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTag("small", 31, 0));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTag("small", 31, 19));
        Assert.assertEquals(50L, lst.size());
        lst.addAll(this.fs.getTasksByTag("big", 0, 20));
        Assert.assertEquals(70L, lst.size());
        lst.addAll(this.fs.getTasksByTag("big", 20, 30));
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getTasksByTitle("smaller", 0, 25);
        Assert.assertEquals(25L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("smaller", 25, 5));
        Assert.assertEquals(30L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("smaller", 30, 1));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("smaller", 31, 0));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("smaller", 31, 19));
        Assert.assertEquals(50L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("bigger", 0, 20));
        Assert.assertEquals(70L, lst.size());
        lst.addAll(this.fs.getTasksByTitle("bigger", 20, 30));
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
        lst = this.fs.getTasksByTitleSubstring("small", 0, 25);
        Assert.assertEquals(25L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("small", 25, 5));
        Assert.assertEquals(30L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("small", 30, 1));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("small", 31, 0));
        Assert.assertEquals(31L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("small", 31, 19));
        Assert.assertEquals(50L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("big", 0, 20));
        Assert.assertEquals(70L, lst.size());
        lst.addAll(this.fs.getTasksByTitleSubstring("big", 20, 30));
        Assert.assertEquals(100L, lst.size());
        this.compareTaskLists(tasks, lst);
    }

    private void compareTaskLists(TaskID[] tasks, List<TaskRecord> lst) {
        Assert.assertEquals(tasks.length, lst.size());
        Object[] a = new String[tasks.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = tasks[i].toString();
        }
        Arrays.sort(a);
        Object[] b = new String[lst.size()];
        for (int i = 0; i < lst.size(); ++i) {
            b[i] = lst.get(i).getTaskId().toString();
        }
        Arrays.sort(b);
        Assert.assertTrue(Arrays.equals(a, b));
    }

    @Test
    public void testDuplicateTags() throws XTraceException {
        if (!this.canTest) {
            return;
        }
        TaskID taskId = new TaskID(8);
        Report report = this.randomReport(new XTraceMetadata(taskId, 0));
        report.put("Tag", "tag1");
        report.put("Tag", "tag1");
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals(1L, this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE).size());
        List<String> tags = this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE).get(0).getTags();
        Assert.assertEquals(1L, tags.size());
        Assert.assertEquals("tag1", tags.get(0));
        Assert.assertEquals(0L, this.fs.getTasksByTag("tag1,tag1", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(0L, this.fs.getTasksByTag("ta", 0, Integer.MAX_VALUE).size());
        report = this.randomReport(new XTraceMetadata(taskId, 1));
        report.put("Tag", "tag1");
        report.put("Tag", "tag2");
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals(1L, this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTag("tag2", 0, Integer.MAX_VALUE).size());
        tags = this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE).get(0).getTags();
        Assert.assertEquals(2L, tags.size());
        Assert.assertEquals(0L, this.fs.getTasksByTag("tag1,tag1", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(0L, this.fs.getTasksByTag("ta", 0, Integer.MAX_VALUE).size());
    }

    @Test
    public void testTitleOperations() throws XTraceException {
        if (!this.canTest) {
            return;
        }
        TaskID taskId = new TaskID(8);
        Report report = this.randomReport(new XTraceMetadata(taskId, 0));
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals(taskId.toString(), this.fs.getLatestTasks(0, 1).get(0).getTitle());
        Assert.assertEquals(1L, this.fs.getTasksByTitle(taskId.toString(), 0, Integer.MAX_VALUE).size());
        report = this.randomReport(new XTraceMetadata(taskId, 1));
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals(taskId.toString(), this.fs.getLatestTasks(0, 1).get(0).getTitle());
        Assert.assertEquals(1L, this.fs.getTasksByTitle(taskId.toString(), 0, Integer.MAX_VALUE).size());
        report = this.randomReport(new XTraceMetadata(taskId, 2));
        report.put("Title", "title1");
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals("title1", this.fs.getLatestTasks(0, 1).get(0).getTitle());
        Assert.assertEquals(0L, this.fs.getTasksByTitle(taskId.toString(), 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTitle("title1", 0, Integer.MAX_VALUE).size());
        report = this.randomReport(new XTraceMetadata(taskId, 3));
        report.put("Title", "title2");
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        Assert.assertEquals("title2", this.fs.getLatestTasks(0, 1).get(0).getTitle());
        Assert.assertEquals(0L, this.fs.getTasksByTitle(taskId.toString(), 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(0L, this.fs.getTasksByTitle("title1", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTitle("title2", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTitleSubstring("title2", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTitleSubstring("itle", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(1L, this.fs.getTasksByTitleSubstring("t", 0, Integer.MAX_VALUE).size());
        Assert.assertEquals(0L, this.fs.getTasksByTitleSubstring("title1", 0, Integer.MAX_VALUE).size());
    }

    @Test
    public void testLastUpdatedByTaskID() {
        if (!this.canTest) {
            return;
        }
        this.fs.sync();
        Assert.assertEquals(0L, this.fs.lastUpdatedByTaskId(TaskID.createFromString("00000000")));
        long startTime = System.currentTimeMillis();
        XTraceMetadata md = new XTraceMetadata(new TaskID(8), 0);
        Report report = this.randomReport(md);
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        long afterFirstInsertion = this.fs.lastUpdatedByTaskId(md.getTaskId());
        Assert.assertTrue(afterFirstInsertion > startTime);
        md = new XTraceMetadata(new TaskID(8), 0);
        report = this.randomReport(md);
        this.fs.receiveReport(report.toString());
        this.fs.sync();
        long afterSecondInsertion = this.fs.lastUpdatedByTaskId(md.getTaskId());
        Assert.assertTrue(afterFirstInsertion < afterSecondInsertion);
    }

    @Test
    public void getLatestTasks() {
        if (!this.canTest) {
            return;
        }
        Report[] reports = new Report[10];
        for (int i = 0; i < reports.length; ++i) {
            reports[i] = this.randomReport(new XTraceMetadata(new TaskID(8), this.r.nextInt()));
            this.fs.receiveReport(reports[i].toString());
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fs.sync();
        List<TaskRecord> tasks = this.fs.getLatestTasks(0, 1);
        Assert.assertEquals(1L, tasks.size());
        Assert.assertEquals(reports[9].getMetadata().getTaskId(), tasks.get(0).getTaskId());
        tasks = this.fs.getLatestTasks(0, 2);
        Assert.assertEquals(2L, tasks.size());
        Assert.assertEquals(reports[9].getMetadata().getTaskId(), tasks.get(0).getTaskId());
        Assert.assertEquals(reports[8].getMetadata().getTaskId(), tasks.get(1).getTaskId());
    }

    @Test
    public void getTasksByTag() {
        int i;
        if (!this.canTest) {
            return;
        }
        Report[] reports = new Report[10];
        for (i = 0; i < reports.length; ++i) {
            reports[i] = this.randomReport(new XTraceMetadata(new TaskID(8), this.r.nextInt()));
        }
        reports[2].put("Tag", "tag1");
        reports[4].put("Tag", "tag2");
        reports[5].put("Tag", "tag2");
        reports[6].put("Tag", "tag3");
        reports[6].put("Tag", "tag4");
        for (i = 0; i < reports.length; ++i) {
            this.fs.receiveReport(reports[i].toString());
        }
        this.fs.sync();
        List<TaskRecord> nulllst = this.fs.getTasksByTag("foobar", 0, Integer.MAX_VALUE);
        Assert.assertNotNull(nulllst);
        Assert.assertEquals(0L, nulllst.size());
        List<TaskRecord> lst = this.fs.getTasksByTag("tag1", 0, Integer.MAX_VALUE);
        Assert.assertNotNull(lst);
        Assert.assertEquals(1L, lst.size());
        Assert.assertEquals(reports[2].getMetadata().getTaskId(), lst.get(0).getTaskId());
        TaskID report4 = reports[4].getMetadata().getTaskId();
        TaskID report5 = reports[5].getMetadata().getTaskId();
        lst = this.fs.getTasksByTag("tag2", 0, Integer.MAX_VALUE);
        Assert.assertNotNull(lst);
        Assert.assertEquals(2L, lst.size());
        Assert.assertTrue(report4.equals(lst.get(0).getTaskId()) && report5.equals(lst.get(1).getTaskId()) || report5.equals(lst.get(0).getTaskId()) && report4.equals(lst.get(1).getTaskId()));
        TaskID report6 = reports[6].getMetadata().getTaskId();
        lst = this.fs.getTasksByTag("tag3", 0, Integer.MAX_VALUE);
        Assert.assertNotNull(lst);
        Assert.assertEquals(1L, lst.size());
        Assert.assertEquals(report6, lst.get(0).getTaskId());
        lst = this.fs.getTasksByTag("tag4", 0, Integer.MAX_VALUE);
        Assert.assertNotNull(lst);
        Assert.assertEquals(1L, lst.size());
        Assert.assertEquals(report6, lst.get(0).getTaskId());
    }

    @After
    public void tearDown() throws Exception {
        this.fs.shutdown();
        FileTreeReportStoreTest.deleteDir(this.testDirectory);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileTreeReportStoreTest.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private Report randomReport(XTraceMetadata md) {
        Report report = new Report();
        report.put("X-Trace", md.toString());
        int numKeys = this.r.nextInt(15);
        for (int i = 0; i < numKeys; ++i) {
            report.put("Key" + i, this.randomString(10 + this.r.nextInt(20)));
        }
        return report;
    }

    private String randomString(int length) {
        char[] ar = new char[length];
        for (int i = 0; i < length; ++i) {
            ar[i] = (char)(97 + this.r.nextInt(25));
        }
        return new String(ar);
    }
}

