/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.server.ReportSource;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class TcpReportSource
implements ReportSource {
    private static final Logger LOG = Logger.getLogger(TcpReportSource.class);
    private static final int MAX_REPORT_LENGTH = 262144;
    private int tcpport;
    private BlockingQueue<String> q;
    private ServerSocket serversock;

    @Override
    public void initialize() throws XTraceException {
        String tcpportstr = System.getProperty("xtrace.backend.tcpport", "7831");
        try {
            this.tcpport = Integer.parseInt(tcpportstr);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Invalid tcp report port: " + tcpportstr, nfe);
            this.tcpport = 7831;
        }
        try {
            this.serversock = new ServerSocket(this.tcpport);
        }
        catch (IOException e) {
            throw new XTraceException("Unable to open TCP server socket", e);
        }
    }

    @Override
    public void setReportQueue(BlockingQueue<String> q) {
        this.q = q;
    }

    @Override
    public void shutdown() {
        try {
            this.serversock.close();
        }
        catch (IOException e) {
            LOG.warn("Unable to close TCP server socket", e);
        }
    }

    @Override
    public void run() {
        try {
            LOG.info("TcpReportSource started on port " + this.tcpport);
            while (true) {
                Socket sock = this.serversock.accept();
                new TcpClientHandler(sock).start();
            }
        }
        catch (IOException e) {
            LOG.warn("Error while accepting a TCP client", e);
            return;
        }
    }

    private final class TcpClientHandler
    extends Thread {
        private Socket sock;

        public TcpClientHandler(Socket sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            try {
                LOG.info("Starting TcpClientHandler for " + this.sock.getInetAddress() + ":" + this.sock.getPort());
                byte[] buf = new byte[262144];
                DataInputStream in = new DataInputStream(this.sock.getInputStream());
                while (true) {
                    int length;
                    if ((length = in.readInt()) <= 0 || length > 262144) {
                        LOG.info("Closing ReadReportsThread for " + this.sock.getInetAddress() + ":" + this.sock.getPort() + " due to bad length: " + length);
                        this.sock.close();
                        return;
                    }
                    in.readFully(buf, 0, length);
                    String message = new String(buf, 0, length, "UTF-8");
                    TcpReportSource.this.q.offer(message);
                }
            }
            catch (EOFException e) {
                LOG.info("Closing ReadReportsThread for " + this.sock.getInetAddress() + ":" + this.sock.getPort() + " normally (EOF)");
            }
            catch (Exception e) {
                LOG.warn("Closing ReadReportsThread for " + this.sock.getInetAddress() + ":" + this.sock.getPort(), e);
            }
        }
    }
}

