/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.xtrace.server;

import edu.berkeley.xtrace.XTraceException;
import edu.berkeley.xtrace.server.ReportSource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class UdpReportSource
implements ReportSource {
    private static final Logger LOG = Logger.getLogger(UdpReportSource.class);
    private BlockingQueue<String> q;
    private DatagramSocket socket;

    @Override
    public void initialize() throws XTraceException {
        InetAddress localAddr;
        String udpSource = System.getProperty("xtrace.udpsource", "127.0.0.1:7831");
        try {
            localAddr = InetAddress.getByName(udpSource.split(":")[0]);
        }
        catch (UnknownHostException e) {
            throw new XTraceException("Unknown host: " + udpSource.split(":")[0], e);
        }
        int localPort = Integer.parseInt(udpSource.split(":")[1]);
        try {
            this.socket = new DatagramSocket(localPort, localAddr);
        }
        catch (SocketException e) {
            throw new XTraceException("Unable to open socket", e);
        }
        LOG.info("UDPReportSource initialized on " + localAddr + ":" + localPort);
    }

    @Override
    public void setReportQueue(BlockingQueue<String> q) {
        this.q = q;
    }

    @Override
    public void shutdown() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public void run() {
        LOG.info("UDPReportSource listening for packets");
        while (true) {
            byte[] buf = new byte[4096];
            DatagramPacket p = new DatagramPacket(buf, buf.length);
            try {
                this.socket.receive(p);
            }
            catch (IOException e) {
                LOG.warn("Unable to receive report", e);
            }
            try {
                this.q.offer(new String(p.getData(), 0, p.getLength(), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("UTF-8 not available", e);
                continue;
            }
            break;
        }
    }
}

