import org.apache.hadoop.hbase.{HBaseConfiguration, HTableDescriptor}
import org.apache.hadoop.hbase.mapreduce.TableInputFormat

import org.apache.spark.rdd.NewHadoopRDD

val conf = HBaseConfiguration.create()
conf.set(TableInputFormat.INPUT_TABLE, "chukwa")


object ChukwaHBase {
  def load(timeRange:Array[Long], metrics:Array[String], source:Array[String],tags:Array[String]) {
    var hBaseRDD = sc.newAPIHadoopRDD(conf, classOf[TableInputFormat], classOf[org.apache.hadoop.hbase.io.ImmutableBytesWritable], classOf[org.apache.hadoop.hbase.client.Result])

    hBaseRDD.map(tuple => tuple._2).map(result => (
        result.getRow, 
        result.getColumn("cf".getBytes(), 
        "val".getBytes()))).map(row => {
    (
      row._1.map(_.toChar).mkString,
      row._2.asScala.reduceLeft {
        (a, b) => if (a.getTimestamp > b.getTimestamp) a else b
      }.getValue
    )
    }).take(10)
  }

  def save(metrics: (String, Double, Long, String)) {
  }
}
