/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.chukwa.extraction.demux;

import org.apache.hadoop.chukwa.datatrigger.TriggerAction;
import org.apache.hadoop.chukwa.datatrigger.TriggerEvent;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.conf.Configuration;

import java.io.IOException;
import java.util.Collection;
import java.util.ArrayList;

public class MockTriggerAction implements TriggerAction {

  private static Collection<TriggerEvent> triggerEvents = new ArrayList<TriggerEvent>();

  public void execute(Configuration conf, FileSystem fs,
                      FileStatus[] src, TriggerEvent event) throws IOException {
    triggerEvents.add(event);
  }

  public static void reset() {
    triggerEvents = new ArrayList<TriggerEvent>();
  }

  public static Collection<TriggerEvent> getTriggerEvents() {
    return triggerEvents;
  }
}
