/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */
package org.apache.devicemap;

public class Util {

    /*
     * normalizes a pattern
     */
    public static String normalize(String p) {
        if (p == null) {
            return p;
        }

        p = p.toLowerCase().trim();

        p = p.replaceAll("\\[bb\\]", "b");

        StringBuilder ret = new StringBuilder();

        for (int i = 0; i < p.length(); i++) {
            Character c = p.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                ret.append(c);
            }
        }

        return ret.toString();
    }

    public static void errorLog(String msg) {
        System.err.println("[devicemapjava] ERROR: " + msg);
    }

    public static void debugLog(String msg) {
        if (System.getProperty("debug") == null) {
            return;
        }
        System.out.println("[devicemapjava] " + msg);
    }
}
