/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */
package org.apache.devicemap.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Pattern {

    //all patterns strings in the inner list need to match (AND)
    //only 1 outer list of patterns need to match (OR)
    private final List<List<String>> patterns;

    public Pattern() {
        patterns = new ArrayList<List<String>>();
    }

    @Override
    public String toString() {
        return patterns.toString();
    }

    /*
     * add the patterns together as an inner list (AND)
     */
    public void setAndPattern(List<String> patterns) {
        this.patterns.add(patterns);
    }

    /*
     * add each pattern on its own list (OR)
     */
    public void setOrPattern(List<String> patterns) {
        for (String pattern : patterns) {
            setPattern(pattern);
        }
    }

    /*
     * add a single pattern (OR)
     */
    public void setPattern(String pattern) {
        List<String> single = new ArrayList<String>();
        single.add(pattern);
        patterns.add(single);
    }

    public List<List<String>> getPatterns() {
        return patterns;
    }

    /*
     * does the set of patterns match this object?
     */
    public boolean isValid(Set<String> patterns) {
        boolean found = false;
        patterns:
        for (List<String> patternset : getPatterns()) {
            for (String pattern : patternset) {
                if (!patterns.contains(pattern)) {
                    continue patterns;
                }
            }
            found = true;
            break;
        }

        return found;
    }

}
