/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */

package org.apache.devicemap.loader;

import org.apache.devicemap.loader.impl.DDRLoader;
import org.apache.devicemap.loader.resource.JarResource;
import org.apache.devicemap.loader.resource.FileResource;
import org.apache.devicemap.loader.impl.NoopLoader;
import org.apache.devicemap.loader.resource.URLResource;
import org.apache.devicemap.loader.impl.UninitializedLoader;

public class LoaderFactory {

    public static Loader getLoader(LoaderOption option, String path) {
        switch (option) {
            case JAR: {
                return new DDRLoader(new JarResource(path));
            }
            case FOLDER: {
                return new DDRLoader(new FileResource(path));
            }
            case URL: {
                return new DDRLoader(new URLResource(path));
            }
            case NOOP: {
                return new NoopLoader();
            }
        }
        return new UninitializedLoader();
    }
}
