/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */
package org.apache.devicemap.loader.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.devicemap.loader.Resource;

public class URLResource implements Resource {

    //TODO: put on CDN of some kind
    private static final String DEFAULT_PATH = "http://svn.apache.org/repos/asf/incubator/devicemap/trunk/data/device-data/src/main/resources/devicedata";

    private final String path;

    public URLResource(String path) {
        if (path == null) {
            this.path = DEFAULT_PATH;
        } else {
            this.path = path;
        }
    }

    @Override
    public InputStream getResource(String file) throws IOException {
        String rpath = path + "/" + file;
        return new URL(rpath).openStream();
    }

}
