/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */
package org.apache.devicemap;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

import org.apache.devicemap.loader.LoaderOption;

public class DeviceMapClientFileTestOptional {

    @Test
    public void DeviceMapClientFolderTest() throws Exception {
        DeviceMapClient client = new DeviceMapClient();

        client.initDeviceData(LoaderOption.FOLDER, "../../../data/device-data/src/main/resources/devicedata");

        String test = "Mozilla/5.0 (Linux; U; Android 2.2; en; HTC Aria A6380 Build/ERE27) AppleWebKit/540.13+ (KHTML, like Gecko) Version/3.1 Mobile Safari/524.15.0";

        Map<String, String> m = client.classify(test);

        Assert.assertEquals("test ua not htc aria", "HTC Aria", m.get("id"));
    }
}
