/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */
package org.apache.devicemap;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import org.apache.devicemap.loader.LoaderOption;

@RunWith(value = Parameterized.class)
public class DeviceMapClientTest {

    private static DeviceMapClient client;

    @BeforeClass
    public static void setupDeviceMapClient() throws Exception {
        client = new DeviceMapClient();
        client.initDeviceData(LoaderOption.JAR);
    }

    @Parameters
    public static Collection<Object[]> data() throws Exception {
        Collection<Object[]> params = new ArrayList<Object[]>();

        BufferedReader reader = new BufferedReader(new InputStreamReader(DeviceMapClientTest.class.getResourceAsStream("/uas.data")));
        String line;

        while ((line = reader.readLine()) != null) {
            params.add(line.split("\\|\\|"));
        }

        reader.close();

        return params;
    }

    private final String testString;
    private final String resultId;

    public DeviceMapClientTest(String testString, String resultId) {
        this.testString = testString;
        this.resultId = resultId;
    }

    @Test
    public void DeviceMapClientTest() throws Exception {
        Map<String, String> m = client.classify(testString);

        Assert.assertEquals("classification failed for '" + testString + "'", resultId, m.get("id"));
    }
}
