/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.apache.felix.karaf.main.BootstrapLogManager;

public class Statements {
    private static Logger LOG = Logger.getLogger(Statements.class.getName());
    private String lockTableName = "KARAF_LOCK";
    private String clusterName = "karaf";
    private String dbName = "sample";
    private String lockCreateStatement;
    private String lockDBCreateStatement;
    private String lockPopulateStatement;

    public Statements(String tableName, String clusterName) {
        LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        this.lockTableName = tableName;
        this.clusterName = clusterName;
        this.lockCreateStatement = "create table " + this.lockTableName + " (TIME bigint, CLUSTER varchar(20))";
        this.lockPopulateStatement = "insert into " + this.lockTableName + " (TIME, CLUSTER) values (1, '" + clusterName + "')";
    }

    public Statements(String dbName, String tableName, String clusterName) {
        LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        this.dbName = dbName;
        this.lockTableName = tableName;
        this.clusterName = clusterName;
        this.lockDBCreateStatement = "create database if not exists " + dbName;
        this.lockCreateStatement = "create table " + this.lockTableName + " (TIME bigint, CLUSTER varchar(20)) ENGINE = INNODB";
        this.lockPopulateStatement = "insert into " + this.lockTableName + " (TIME, CLUSTER) values (1, '" + clusterName + "')";
    }

    public String setUpdateCursor() {
        String test = "SELECT * FROM " + this.lockTableName + " FOR UPDATE";
        return test;
    }

    public String getLockUpdateStatement(long timeStamp) {
        String lockUpdateStatement = "";
        lockUpdateStatement = "UPDATE " + this.lockTableName + " SET TIME=" + timeStamp + " WHERE CLUSTER = '" + this.clusterName + "'";
        return lockUpdateStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Connection lockConnection, String dbName) {
        Statement s = null;
        try {
            s = lockConnection.createStatement();
            s.execute(this.lockDBCreateStatement);
        }
        catch (SQLException e) {
            LOG.severe("SQL Exception: " + e + " " + e.getMessage());
        }
        catch (Exception ignore) {
            LOG.severe("Could not create database: " + ignore + " " + ignore.getMessage());
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Connection lockConnection) {
        Statement s = null;
        try {
            boolean alreadyExists = false;
            ResultSet rs = null;
            try {
                rs = lockConnection.getMetaData().getTables(null, null, this.lockTableName, new String[]{"TABLE"});
                alreadyExists = rs.next();
            }
            catch (Throwable ignore) {
                try {
                    LOG.severe("Error testing for db table: " + ignore);
                }
                catch (Throwable throwable) {
                    Statements.close(rs);
                    throw throwable;
                }
                Statements.close(rs);
            }
            Statements.close(rs);
            if (alreadyExists) {
                return;
            }
            s = lockConnection.createStatement();
            String[] createStatments = new String[]{this.lockCreateStatement, this.lockPopulateStatement};
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    LOG.severe("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                }
            }
            lockConnection.commit();
        }
        catch (Exception ignore) {
            LOG.severe("Error occured during initialization: " + ignore);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable e) {
                LOG.severe("Error occured while closing connection: " + e);
            }
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable e) {
            LOG.severe("Error occured while releasing ResultSet: " + e);
        }
    }
}

