/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannel
implements Channel {
    public static final int DEFAULT_WINDOW_SIZE = 0x200000;
    public static final int DEFAULT_PACKET_SIZE = 32768;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Object lock = new Object();
    protected final Window localWindow = new Window(this, null, this.getClass().getName().contains(".client."), true);
    protected final Window remoteWindow = new Window(this, null, this.getClass().getName().contains(".client."), false);
    protected Session session;
    protected int id;
    protected int recipient;
    protected boolean eof;
    protected final CloseFuture closeFuture = new DefaultCloseFuture(this.lock);
    protected boolean closing;

    public int getId() {
        return this.id;
    }

    public int getRecipient() {
        return this.recipient;
    }

    public Window getLocalWindow() {
        return this.localWindow;
    }

    public Session getSession() {
        return this.session;
    }

    public void handleRequest(Buffer buffer) throws IOException {
        throw new IllegalStateException();
    }

    public void init(Session session, int id) {
        this.session = session;
        this.id = id;
        this.configureWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseFuture close(boolean immediately) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (immediately) {
                    this.log.info("Closing channel {} immediately", (Object)this.id);
                    this.closeFuture.setClosed();
                    this.session.unregisterChannel(this);
                } else if (!this.closing) {
                    this.closing = true;
                    this.log.info("Send SSH_MSG_CHANNEL_CLOSE on channel {}", (Object)this.id);
                    Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_CLOSE);
                    buffer.putInt(this.recipient);
                    this.session.writePacket(buffer);
                }
            }
        }
        catch (IOException e) {
            this.session.exceptionCaught(e);
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClose() throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_CLOSE on channel {}", (Object)this.id);
        Object object = this.lock;
        synchronized (object) {
            this.close(false).setClosed();
            this.doClose();
            this.lock.notifyAll();
        }
    }

    protected void doClose() {
    }

    public void handleData(Buffer buffer) throws IOException {
        int len = buffer.getInt();
        if (len < 0 || len > 32768) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_DATA on channel {}", (Object)this.id);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteData(buffer.array(), buffer.rpos(), len);
    }

    public void handleExtendedData(Buffer buffer) throws IOException {
        int ex = buffer.getInt();
        if (ex != 1) {
            this.log.info("Send SSH_MSG_CHANNEL_FAILURE on channel {}", (Object)this.id);
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
            return;
        }
        int len = buffer.getInt();
        if (len < 0 || len > 32768) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_EXTENDED_DATA on channel {}", (Object)this.id);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel extended data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteExtendedData(buffer.array(), buffer.rpos(), len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEof() throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_EOF on channel {}", (Object)this.id);
        Object object = this.lock;
        synchronized (object) {
            this.eof = true;
            this.lock.notifyAll();
        }
    }

    public void handleWindowAdjust(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", (Object)this.id);
        int window = buffer.getInt();
        this.remoteWindow.expand(window);
    }

    public void handleFailure() throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_FAILURE on channel {}", (Object)this.id);
    }

    protected abstract void doWriteData(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doWriteExtendedData(byte[] var1, int var2, int var3) throws IOException;

    protected void sendEof() throws IOException {
        this.log.info("Send SSH_MSG_CHANNEL_EOF on channel {}", (Object)this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_EOF);
        buffer.putInt(this.recipient);
        this.session.writePacket(buffer);
    }

    protected void configureWindow() {
        int window = this.session.getIntProperty("window-size", 0x200000);
        int packet = this.session.getIntProperty("packet-size", 32768);
        this.localWindow.init(window, packet);
    }

    protected void sendWindowAdjust(int len) throws IOException {
        this.log.info("Send SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", (Object)this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_WINDOW_ADJUST);
        buffer.putInt(this.recipient);
        buffer.putInt(len);
        this.session.writePacket(buffer);
    }
}

