/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.PaxLoggingConfigurator;
import org.knopflerfish.service.log.LogService;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.AppenderTracker;
import org.ops4j.pax.logging.internal.LogEntryImpl;
import org.ops4j.pax.logging.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.internal.PaxLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
LogService,
ManagedService,
ServiceFactory {
    private LogReaderServiceImpl m_logReader;
    private EventAdminPoster m_eventAdmin;
    private BundleContext m_bundleContext;
    private AppenderTracker m_appenderTracker;
    private PaxContext m_context;
    private int m_logLevel = 4;
    private static final String DEFAULT_SERVICE_LOG_LEVEL = "org.ops4j.pax.logging.DefaultServiceLog.level";

    public PaxLoggingServiceImpl(BundleContext context, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin, AppenderTracker appenderTracker) {
        this.m_bundleContext = context;
        this.m_appenderTracker = appenderTracker;
        this.m_logReader = logReader;
        this.m_eventAdmin = eventAdmin;
        this.m_context = new PaxContext();
        this.configureDefaults();
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger(category);
        return new PaxLoggerImpl(bundle, log4jLogger, fqcn, this);
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log((ServiceReference)null, level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(null, sr, level, message, exception);
    }

    void log(Bundle bundle, int level, String message, Throwable exception) {
        this.log(bundle, null, level, message, exception);
    }

    private void log(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        if (null == bundle && null != sr) {
            bundle = sr.getBundle();
        }
        String category = "[undefined]";
        if (bundle != null && null == (category = bundle.getSymbolicName())) {
            category = "[bundle@" + bundle.getBundleId() + ']';
        }
        PaxLogger logger = this.getLogger(bundle, category, "");
        switch (level) {
            case 1: {
                logger.error(message, exception);
                break;
            }
            case 2: {
                logger.warn(message, exception);
                break;
            }
            case 3: {
                logger.inform(message, exception);
                break;
            }
            case 4: {
                logger.debug(message, exception);
                break;
            }
            default: {
                logger.warn("Undefined Level: " + level + " : " + message, exception);
            }
        }
        this.handleEvents(bundle, sr, level, message, exception);
    }

    void handleEvents(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        LogEntryImpl entry = new LogEntryImpl(bundle, sr, level, message, exception);
        this.m_logReader.fireEvent(entry);
        if (this.m_eventAdmin != null) {
            this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
        }
    }

    public void updated(Dictionary configuration) throws ConfigurationException {
        if (configuration == null) {
            this.configureDefaults();
            return;
        }
        Properties extracted = this.extractKeys(configuration);
        if (extracted.size() == 0) {
            this.configureDefaults();
            return;
        }
        PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_appenderTracker);
        configurator.doConfigure(extracted, LogManager.getLoggerRepository());
        PaxLoggingServiceImpl.setLevelToJavaLogging(configuration);
    }

    private Properties extractKeys(Dictionary configuration) {
        Properties extracted = new Properties();
        Enumeration list = configuration.keys();
        while (list.hasMoreElements()) {
            Object obj = list.nextElement();
            if (!(obj instanceof String)) continue;
            this.extractKey(extracted, configuration, obj);
        }
        return extracted;
    }

    private void extractKey(Properties extracted, Dictionary configuration, Object obj) {
        String key = (String)obj;
        Object value = configuration.get(obj);
        if (key.startsWith("log4j")) {
            extracted.put(key, value);
        } else if (key.startsWith("pax.") && "pax.logging.entries.size".equals(key)) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void configureDefaults() {
        String levelName;
        levelName = this.m_bundleContext == null ? System.getProperty(DEFAULT_SERVICE_LOG_LEVEL, "DEBUG").trim() : ((levelName = this.m_bundleContext.getProperty(DEFAULT_SERVICE_LOG_LEVEL)) == null ? "DEBUG" : levelName.trim());
        this.m_logLevel = PaxLoggingServiceImpl.convertLevel(levelName);
        PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_appenderTracker);
        Properties defaultProperties = new Properties();
        this.extractSystemProperties(defaultProperties);
        defaultProperties.put("log4j.rootLogger", PaxLoggingServiceImpl.convertLevel(this.m_logLevel) + ", A1");
        defaultProperties.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        defaultProperties.put("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        configurator.doConfigure(defaultProperties, LogManager.getLoggerRepository());
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.FINE);
    }

    private void extractSystemProperties(Properties output) {
        Iterator<Map.Entry<Object, Object>> list = System.getProperties().entrySet().iterator();
        while (list.hasNext()) {
            Map.Entry<Object, Object> entry = list.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("pax.log4j")) continue;
            key = key.substring(4);
            output.put(key, value);
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService,
        LogService,
        ManagedService {
            private final /* synthetic */ Bundle val$bundle;

            ManagedPaxLoggingService(Bundle bundle) {
                this.val$bundle = bundle;
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, null, level, message, null);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, null, level, message, exception);
            }

            public void log(ServiceReference sr, int level, String message) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, sr, level, message, null);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, sr, level, message, exception);
            }

            public int getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public void updated(Dictionary configuration) throws ConfigurationException {
                PaxLoggingServiceImpl.this.updated(configuration);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }
        }
        return new ManagedPaxLoggingService(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public PaxContext getPaxContext() {
        return this.m_context;
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equals(levelName)) {
            return 4;
        }
        if ("INFO".equals(levelName)) {
            return 3;
        }
        if ("ERROR".equals(levelName)) {
            return 1;
        }
        return 4;
    }

    private static String convertLevel(int level) {
        switch (level) {
            case 4: {
                return "DEBUG";
            }
            case 3: {
                return "INFO";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    private static void setLevelToJavaLogging(Dictionary configuration) {
        String levelProperty = null;
        Enumeration en = configuration.keys();
        while (en.hasMoreElements()) {
            Object value;
            String keyString;
            Object key = en.nextElement();
            if (key == null || !(key instanceof String) || !(keyString = ((String)key).trim().toLowerCase()).startsWith("log4j") || keyString.indexOf("rootlogger") == -1 || (value = configuration.get(key)) == null || !(value instanceof String)) continue;
            levelProperty = ((String)value).trim().toUpperCase();
        }
        if (levelProperty == null) {
            return;
        }
        PaxLoggingServiceImpl.setLevelToRootLogger(levelProperty);
    }

    private static void setLevelToRootLogger(String levelProperty) {
        Logger rootLogger = Logger.getLogger("");
        if (levelProperty.indexOf("OFF") != -1) {
            rootLogger.setLevel(Level.OFF);
        } else if (levelProperty.indexOf("FATAL") != -1) {
            rootLogger.setLevel(Level.SEVERE);
        } else if (levelProperty.indexOf("ERROR") != -1) {
            rootLogger.setLevel(Level.SEVERE);
        } else if (levelProperty.indexOf("WARN") != -1) {
            rootLogger.setLevel(Level.WARNING);
        } else if (levelProperty.indexOf("INFO") != -1) {
            rootLogger.setLevel(Level.INFO);
        } else if (levelProperty.indexOf("DEBUG") != -1) {
            rootLogger.setLevel(Level.FINE);
        } else if (levelProperty.indexOf("TRACE") != -1) {
            rootLogger.setLevel(Level.FINEST);
        }
    }
}

