/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.console.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.felix.karaf.shell.console.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringsCompleter
implements Completer {
    private final SortedSet<String> strings = new TreeSet<String>();

    public StringsCompleter() {
    }

    public StringsCompleter(Collection<String> strings) {
        assert (strings != null);
        this.getStrings().addAll(strings);
    }

    public StringsCompleter(String[] strings) {
        this(Arrays.asList(strings));
    }

    public Collection<String> getStrings() {
        return this.strings;
    }

    public int complete(String buffer, int cursor, List candidates) {
        String match;
        assert (candidates != null);
        if (buffer == null) {
            buffer = "";
        }
        SortedSet<String> matches = this.strings.tailSet(buffer);
        Iterator i$ = matches.iterator();
        while (i$.hasNext() && (match = (String)i$.next()).startsWith(buffer)) {
            candidates.add(match);
        }
        if (candidates.size() == 1) {
            candidates.set(0, candidates.get(0) + " ");
        }
        return candidates.isEmpty() ? -1 : 0;
    }
}

