/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.shell;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    int current = 0;
    CharSequence text;
    boolean escaped;
    static final String SPECIAL = "<;|{[\"'$`(=";

    public Parser(CharSequence program) {
        this.text = program;
    }

    void ws() {
        while (!this.eof() && (!this.escaped && Character.isWhitespace(this.peek()) || this.current == 0)) {
            if (this.current != 0 || !this.escaped && Character.isWhitespace(this.peek())) {
                ++this.current;
            }
            if (this.peek() == '/' && this.current < this.text.length() - 2 && this.text.charAt(this.current + 1) == '/') {
                this.comment();
            }
            if (this.current != 0) continue;
            break;
        }
    }

    private void comment() {
        while (!this.eof() && this.peek() != '\n' && this.peek() != '\r') {
            this.next();
        }
    }

    boolean eof() {
        return this.current >= this.text.length();
    }

    char peek() {
        return this.peek(false);
    }

    char peek(boolean increment) {
        int c;
        this.escaped = false;
        if (this.eof()) {
            return '\u0000';
        }
        int last = this.current;
        if ((c = this.text.charAt(this.current++)) == 92) {
            this.escaped = true;
            if (this.eof()) {
                throw new RuntimeException("Eof found after \\");
            }
            c = this.text.charAt(this.current++);
            switch (c) {
                case 116: {
                    c = 9;
                    break;
                }
                case 10: 
                case 13: {
                    c = 32;
                    break;
                }
                case 98: {
                    c = 8;
                    break;
                }
                case 102: {
                    c = 12;
                    break;
                }
                case 110: {
                    c = 10;
                    break;
                }
                case 114: {
                    c = 13;
                    break;
                }
                case 117: {
                    c = this.unicode();
                    this.current += 4;
                    break;
                }
            }
        }
        if (!increment) {
            this.current = last;
        }
        return (char)c;
    }

    public List<List<List<CharSequence>>> program() {
        ArrayList<List<List<CharSequence>>> program = new ArrayList<List<List<CharSequence>>>();
        this.ws();
        if (!this.eof()) {
            program.add(this.statements());
            while (this.peek() == '|') {
                ++this.current;
                program.add(this.statements());
            }
        }
        if (!this.eof()) {
            throw new RuntimeException("Program has trailing text: " + this.context(this.current));
        }
        return program;
    }

    CharSequence context(int around) {
        return this.text.subSequence(Math.max(0, this.current - 20), Math.min(this.text.length(), this.current + 4));
    }

    public List<List<CharSequence>> statements() {
        ArrayList<List<CharSequence>> statements = new ArrayList<List<CharSequence>>();
        statements.add(this.statement());
        while (this.peek() == ';') {
            ++this.current;
            this.ws();
            if (this.eof()) continue;
            statements.add(this.statement());
        }
        return statements;
    }

    public List<CharSequence> statement() {
        ArrayList<CharSequence> statement = new ArrayList<CharSequence>();
        statement.add(this.value());
        while (!this.eof()) {
            this.ws();
            if (this.peek() == '|' || this.peek() == ';') break;
            if (this.eof()) continue;
            statement.add(this.messy());
        }
        return statement;
    }

    public CharSequence messy() {
        char c = this.peek();
        if (c > '\u0000' && SPECIAL.indexOf(c) < 0) {
            int start = this.current++;
            while (!this.eof()) {
                c = this.peek();
                if (!this.escaped && (c == ';' || c == '|' || Character.isWhitespace(c))) break;
                this.next();
            }
            return this.text.subSequence(start, this.current);
        }
        return this.value();
    }

    CharSequence value() {
        this.ws();
        int start = this.current;
        char c = this.next();
        if (!this.escaped) {
            switch (c) {
                case '{': {
                    return this.text.subSequence(start, this.find('}', '{'));
                }
                case '(': {
                    return this.text.subSequence(start, this.find(')', '('));
                }
                case '[': {
                    return this.text.subSequence(start, this.find(']', '['));
                }
                case '<': {
                    return this.text.subSequence(start, this.find('>', '<'));
                }
                case '=': {
                    return this.text.subSequence(start, this.current);
                }
                case '\"': 
                case '\'': {
                    this.quote(c);
                }
            }
        }
        while (!this.eof()) {
            c = this.peek();
            if (!this.escaped) {
                if (Character.isWhitespace(c) || c == ';' || c == '|' || c == '=') break;
                if (c == '{') {
                    this.next();
                    this.find('}', '{');
                    continue;
                }
                if (c == '(') {
                    this.next();
                    this.find(')', '(');
                    continue;
                }
                if (c == '<') {
                    this.next();
                    this.find('>', '<');
                    continue;
                }
                if (c == '[') {
                    this.next();
                    this.find(']', '[');
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    this.next();
                    this.quote(c);
                    this.next();
                    continue;
                }
                this.next();
                continue;
            }
            this.next();
        }
        return this.text.subSequence(start, this.current);
    }

    boolean escaped() {
        return this.escaped;
    }

    char next() {
        return this.peek(true);
    }

    char unicode() {
        if (this.current + 4 > this.text.length()) {
            throw new IllegalArgumentException("Unicode \\u escape at eof at pos ..." + this.context(this.current) + "...");
        }
        String s = ((Object)this.text.subSequence(this.current, this.current + 4)).toString();
        int n = Integer.parseInt(s, 16);
        return (char)n;
    }

    int find(char target, char deeper) {
        int start = this.current;
        int level = 1;
        while (level != 0) {
            if (this.eof()) {
                throw new RuntimeException("Eof found in the middle of a compound for '" + target + deeper + "', begins at " + this.context(start));
            }
            char c = this.next();
            if (this.escaped) continue;
            if (c == target) {
                --level;
                continue;
            }
            if (c == deeper) {
                ++level;
                continue;
            }
            if (c == '\"') {
                this.quote('\"');
                continue;
            }
            if (c == '\'') {
                this.quote('\'');
                continue;
            }
            if (c != '`') continue;
            this.quote('`');
        }
        return this.current;
    }

    int quote(char which) {
        while (!this.eof() && (this.peek() != which || this.escaped)) {
            this.next();
        }
        return this.current++;
    }

    CharSequence findVar() {
        int start = this.current;
        char c = this.peek();
        if (c == '{') {
            this.next();
            int end = this.find('}', '{');
            return this.text.subSequence(start, end);
        }
        if (c == '(') {
            this.next();
            int end = this.find(')', '(');
            return this.text.subSequence(start, end);
        }
        if (Character.isJavaIdentifierPart(c)) {
            while (c == '$') {
                c = this.next();
            }
            while (!this.eof() && (Character.isJavaIdentifierPart(c) || c == '.') && c != '$') {
                this.next();
                c = this.peek();
            }
            return this.text.subSequence(start, this.current);
        }
        throw new IllegalArgumentException("Reference to variable does not match syntax of a variable: " + this.context(start));
    }

    public String toString() {
        return "..." + this.context(this.current) + "...";
    }

    public String unescape() {
        StringBuilder sb = new StringBuilder();
        while (!this.eof()) {
            sb.append(this.next());
        }
        return sb.toString();
    }
}

