/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.bnd;

import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.bnd.BndJarResourceStore;
import org.apache.felix.ipojo.bnd.BndReporter;
import org.apache.felix.ipojo.bnd.ResourceMetadataProvider;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.metadata.AnnotationMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.CacheableMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.CompositeMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.FileMetadataProvider;
import org.apache.felix.ipojo.manipulator.visitor.check.CheckFieldConsistencyVisitor;
import org.apache.felix.ipojo.manipulator.visitor.writer.ManipulatedResourcesWriter;
import org.apache.felix.ipojo.metadata.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoizationPlugin
implements Plugin,
AnalyzerPlugin {
    private static final String PROPERTY_METADATA = "metadata";
    private static final String PROPERTY_USE_LOCAL_SCHEMAS = "use-local-schemas";
    private static final String DEFAULT_METADATA = "META-INF/metadata.xml";
    private static final boolean DEFAULT_USE_LOCAL_SCHEMAS = false;
    private String m_metadata = "META-INF/metadata.xml";
    private boolean m_useLocalSchemas = false;
    private aQute.libg.reporter.Reporter m_reporter;

    public void setProperties(Map<String, String> configuration) {
        if (configuration.containsKey(PROPERTY_METADATA)) {
            this.m_metadata = configuration.get(PROPERTY_METADATA);
        }
        if (configuration.containsKey(PROPERTY_USE_LOCAL_SCHEMAS)) {
            this.m_useLocalSchemas = true;
        }
    }

    public void setReporter(aQute.libg.reporter.Reporter reporter) {
        this.m_reporter = reporter;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        long start = System.currentTimeMillis();
        BndReporter reporter = new BndReporter(this.m_reporter);
        BndJarResourceStore store = new BndJarResourceStore(analyzer, this.m_reporter);
        CompositeMetadataProvider provider = new CompositeMetadataProvider((Reporter)reporter);
        File file = new File(this.m_metadata);
        if (file.exists()) {
            FileMetadataProvider fmp = new FileMetadataProvider(file, (Reporter)reporter);
            fmp.setValidateUsingLocalSchemas(this.m_useLocalSchemas);
            provider.addMetadataProvider((MetadataProvider)fmp);
        } else {
            Resource resource = analyzer.getJar().getResource(this.m_metadata);
            if (resource != null) {
                ResourceMetadataProvider rmp = new ResourceMetadataProvider(resource, (Reporter)reporter);
                rmp.setValidateUsingLocalSchemas(this.m_useLocalSchemas);
                provider.addMetadataProvider((MetadataProvider)rmp);
            }
        }
        provider.addMetadataProvider((MetadataProvider)new AnnotationMetadataProvider((ResourceStore)store, (Reporter)reporter));
        CacheableMetadataProvider cache = new CacheableMetadataProvider((MetadataProvider)provider);
        if (cache.getMetadatas().isEmpty()) {
            return false;
        }
        Pojoization pojoization = new Pojoization((Reporter)reporter);
        pojoization.disableAnnotationProcessing();
        if (this.m_useLocalSchemas) {
            pojoization.setUseLocalXSD();
        }
        pojoization.pojoization((ResourceStore)store, (MetadataProvider)cache, this.createVisitor(store, reporter));
        int nbComponents = this.findElements(cache.getMetadatas(), "component").size();
        int nbHandlers = this.findElements(cache.getMetadatas(), "handler").size();
        this.m_reporter.progress("iPOJO manipulation performed performed in %s ms (%d components, %d handlers).", new Object[]{System.currentTimeMillis() - start, nbComponents, nbHandlers});
        return false;
    }

    private List<Element> findElements(List<Element> metadatas, String name) {
        ArrayList<Element> found = new ArrayList<Element>();
        for (Element element : metadatas) {
            if (!name.equalsIgnoreCase(element.getName())) continue;
            found.add(element);
        }
        return found;
    }

    private ManipulationVisitor createVisitor(ResourceStore store, BndReporter reporter) {
        ManipulatedResourcesWriter writer = new ManipulatedResourcesWriter();
        writer.setReporter((Reporter)reporter);
        writer.setResourceStore(store);
        CheckFieldConsistencyVisitor checkFieldConsistencyVisitor = new CheckFieldConsistencyVisitor((ManipulationVisitor)writer);
        checkFieldConsistencyVisitor.setReporter((Reporter)reporter);
        return checkFieldConsistencyVisitor;
    }
}

