/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.SystemBundle;
import org.apache.felix.framework.SystemBundleActivator;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLHandlersStreamHandlerProxy
extends URLStreamHandler
implements URLStreamHandlerSetter {
    private Map m_trackerMap = new HashMap();
    private String m_protocol = null;

    public URLHandlersStreamHandlerProxy(String protocol) {
        this.m_protocol = protocol;
    }

    protected synchronized boolean equals(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.equals(url1, url2);
    }

    protected synchronized int getDefaultPort() {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Stream handler unavailable.");
        }
        return svc.getDefaultPort();
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.getHostAddress(url);
    }

    protected synchronized int hashCode(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.hashCode(url);
    }

    protected synchronized boolean hostsEqual(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.hostsEqual(url1, url2);
    }

    protected synchronized URLConnection openConnection(URL url) throws IOException {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new MalformedURLException("Unknown protocol: " + url.toString());
        }
        return svc.openConnection(url);
    }

    protected synchronized void parseURL(URL url, String spec, int start, int limit) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        svc.parseURL(this, url, spec, start, limit);
    }

    protected synchronized boolean sameFile(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.sameFile(url1, url2);
    }

    public void setURL(URL url, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(url, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        super.setURL(url, protocol, host, port, null, null, file, null, ref);
    }

    protected synchronized String toExternalForm(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.toExternalForm(url);
    }

    private URLStreamHandlerService getStreamHandlerService() {
        Felix framework = URLHandlers.getFrameworkFromContext();
        if (framework == null) {
            return null;
        }
        URLHandlersServiceTracker tracker = (URLHandlersServiceTracker)this.m_trackerMap.get(framework);
        if (tracker == null) {
            BundleContext context = ((SystemBundleActivator)((SystemBundle)framework.getBundle(0L)).getActivator()).getBundleContext();
            String filter = "(&(objectClass=" + URLStreamHandlerService.class.getName() + ")(" + "url.handler.protocol" + "=" + this.m_protocol + "))";
            tracker = new URLHandlersServiceTracker(context, filter);
            this.m_trackerMap.put(framework, tracker);
        }
        return (URLStreamHandlerService)tracker.getService();
    }
}

