/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.felix.framework.Logger;
import org.apache.felix.moduleloader.IContent;

public abstract class BundleRevision {
    private Logger m_logger;
    private File m_revisionRootDir = null;
    private String m_location = null;
    private Collection m_trustedCaCerts = null;
    private X509Certificate[] m_certificates = null;
    private String[] m_subjectDNChain = null;
    private boolean m_certInitDone = System.getSecurityManager() == null;
    private boolean m_subjectDNInitDone = System.getSecurityManager() == null;
    private byte[] tbs_buffer = null;
    private int tbs_offset = 0;
    private int tbs_tagOffset = 0;
    private int tbs_tag = -1;
    private int tbs_length = -1;
    private int tbs_contentOffset = -1;
    private static final Map OID2NAME = new HashMap();

    BundleRevision() {
    }

    public BundleRevision(Logger logger, File revisionRootDir, String location) throws Exception {
        this.m_logger = logger;
        this.m_revisionRootDir = revisionRootDir;
        this.m_location = location;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public File getRevisionRootDir() {
        return this.m_revisionRootDir;
    }

    public String getLocation() {
        return this.m_location;
    }

    public abstract Map getManifestHeader() throws Exception;

    public abstract IContent getContent() throws Exception;

    public abstract IContent[] getContentPath() throws Exception;

    public abstract String findLibrary(String var1) throws Exception;

    public abstract void dispose() throws Exception;

    protected void setTrustedCaCerts(Collection trustedCaCerts) {
        this.m_trustedCaCerts = trustedCaCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getCertificates() {
        if (this.m_certInitDone) {
            return this.m_certificates;
        }
        if (this.m_trustedCaCerts == null) {
            return null;
        }
        try {
            this.m_certificates = this.getRevisionCertificates();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.m_certInitDone = true;
        }
        return this.m_certificates;
    }

    protected abstract X509Certificate[] getRevisionCertificates() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDNChains() {
        if (this.m_subjectDNInitDone) {
            return this.m_subjectDNChain;
        }
        try {
            Certificate[] certificates = this.getCertificates();
            if (certificates == null) {
                String[] stringArray = null;
                return stringArray;
            }
            ArrayList rootChains = new ArrayList();
            this.getRootChains(certificates, rootChains);
            ArrayList<String> result = new ArrayList<String>();
            Iterator rootIter = rootChains.iterator();
            while (rootIter.hasNext()) {
                StringBuffer buffer = new StringBuffer();
                List chain = (List)rootIter.next();
                Iterator iter = chain.iterator();
                X509Certificate current = (X509Certificate)iter.next();
                try {
                    buffer.append(this.parseSubjectDN(current.getTBSCertificate()));
                    while (iter.hasNext()) {
                        buffer.append(';');
                        current = (X509Certificate)iter.next();
                        buffer.append(this.parseSubjectDN(current.getTBSCertificate()));
                    }
                    result.add(buffer.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!result.isEmpty()) {
                this.m_subjectDNChain = result.toArray(new String[result.size()]);
            }
        }
        finally {
            this.m_subjectDNInitDone = true;
        }
        return this.m_subjectDNChain;
    }

    protected X509Certificate[] getCertificatesForJar(JarFile bundle) throws Exception {
        if (bundle.getManifest() == null) {
            return null;
        }
        ArrayList<JarEntry> bundleEntries = new ArrayList<JarEntry>();
        Enumeration<JarEntry> entries = bundle.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            bundleEntries.add(entry);
            InputStream is = bundle.getInputStream(entry);
            byte[] read = new byte[4096];
            while (is.read(read) != -1) {
            }
            is.close();
        }
        bundle.close();
        ArrayList certificateChains = new ArrayList();
        Iterator iter = bundleEntries.iterator();
        while (iter.hasNext()) {
            JarEntry entry = (JarEntry)iter.next();
            if (entry.isDirectory() || entry.getName().startsWith("META-INF")) continue;
            Certificate[] certificates = entry.getCertificates();
            if (certificates == null || certificates.length == 0) {
                return null;
            }
            ArrayList chains = new ArrayList();
            this.getRootChains(certificates, chains);
            if (certificateChains.isEmpty()) {
                certificateChains.addAll(chains);
            } else {
                Iterator iter2 = certificateChains.iterator();
                while (iter2.hasNext()) {
                    X509Certificate cert = (X509Certificate)((List)iter2.next()).get(0);
                    boolean found = false;
                    Iterator iter3 = chains.iterator();
                    while (iter3.hasNext()) {
                        X509Certificate cert2 = (X509Certificate)((List)iter3.next()).get(0);
                        if (!((Object)cert.getSubjectDN()).equals(cert2.getSubjectDN()) || !cert.equals(cert2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    iter2.remove();
                }
            }
            if (!certificateChains.isEmpty()) continue;
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter2 = certificateChains.iterator();
        while (iter2.hasNext()) {
            result.addAll((List)iter2.next());
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    protected void getRootChains(Certificate[] certificates, List chains) {
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        for (int i = 0; i < certificates.length - 1; ++i) {
            chain.add(certificates[i]);
            if (((Object)((X509Certificate)certificates[i + 1]).getSubjectDN()).equals(((X509Certificate)certificates[i]).getIssuerDN())) continue;
            if (this.trusted((X509Certificate)certificates[i])) {
                chains.add(chain);
            }
            chain = new ArrayList();
        }
        chain.add(certificates[certificates.length - 1]);
        if (this.trusted((X509Certificate)certificates[certificates.length - 1])) {
            chains.add(chain);
        }
    }

    protected boolean trusted(X509Certificate cert) {
        X509Certificate trustedCaCert;
        if (this.m_trustedCaCerts == null) {
            return false;
        }
        Iterator iter = this.m_trustedCaCerts.iterator();
        while (iter.hasNext()) {
            trustedCaCert = (X509Certificate)iter.next();
            if (!((Object)cert.getSubjectDN()).equals(trustedCaCert.getSubjectDN()) || !cert.equals(trustedCaCert)) continue;
            try {
                cert.checkValidity();
                trustedCaCert.checkValidity();
                return true;
            }
            catch (CertificateException ex) {
                System.err.println("WARNING: Invalid certificate [" + ex + "]");
            }
        }
        iter = this.m_trustedCaCerts.iterator();
        while (iter.hasNext()) {
            trustedCaCert = (X509Certificate)iter.next();
            if (!((Object)cert.getIssuerDN()).equals(trustedCaCert.getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCert.getPublicKey());
                cert.checkValidity();
                trustedCaCert.checkValidity();
                return true;
            }
            catch (Exception ex) {
                System.err.println("WARNING: Invalid certificate [" + ex + "]");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String parseSubjectDN(byte[] tbsCertEncoded) throws Exception {
        this.tbs_buffer = tbsCertEncoded;
        this.tbs_offset = 0;
        try {
            List<Object[]> rdn;
            this.next();
            this.next();
            if (this.tbs_tag == 0) {
                this.next();
                this.tbs_offset += this.tbs_length;
            }
            this.tbs_offset += this.tbs_length;
            this.next();
            this.next();
            this.tbs_offset += this.tbs_length;
            this.next();
            this.tbs_offset += this.tbs_length;
            this.next();
            int endOffset = this.tbs_offset + this.tbs_length;
            int seqTagOffset = this.tbs_tagOffset;
            while (endOffset > this.tbs_offset) {
                this.next();
                int endOffset2 = this.tbs_offset + this.tbs_length;
                int seqTagOffset2 = this.tbs_tagOffset;
                while (endOffset2 > this.tbs_offset) {
                    this.next();
                    this.next();
                    this.tbs_offset += this.tbs_length;
                    this.next();
                    this.tbs_offset += this.tbs_length;
                }
                this.tbs_tagOffset = seqTagOffset2;
            }
            this.tbs_tagOffset = seqTagOffset;
            this.next();
            this.next();
            this.tbs_offset += this.tbs_length;
            this.next();
            this.tbs_offset += this.tbs_length;
            this.next();
            ArrayList<List<Object[]>> attributes = new ArrayList<List<Object[]>>();
            endOffset = this.tbs_offset + this.tbs_length;
            seqTagOffset = this.tbs_tagOffset;
            while (endOffset > this.tbs_offset) {
                this.next();
                int endOffset2 = this.tbs_offset + this.tbs_length;
                int seqTagOffset2 = this.tbs_tagOffset;
                rdn = new ArrayList();
                while (endOffset2 > this.tbs_offset) {
                    this.next();
                    this.next();
                    this.tbs_offset += this.tbs_length;
                    int oidElement = 1;
                    int i = 0;
                    while (i < this.tbs_length) {
                        while ((this.tbs_buffer[this.tbs_contentOffset + i] & 0x80) == 128) {
                            ++i;
                        }
                        ++i;
                        ++oidElement;
                    }
                    int[] oid = new int[oidElement];
                    int id = 1;
                    int i2 = 0;
                    while (id < oid.length) {
                        byte octet = this.tbs_buffer[this.tbs_contentOffset + i2];
                        oidElement = octet & 0x7F;
                        while ((octet & 0x80) != 0) {
                            octet = this.tbs_buffer[this.tbs_contentOffset + ++i2];
                            oidElement = oidElement << 7 | octet & 0x7F;
                        }
                        oid[id] = oidElement;
                        ++id;
                        ++i2;
                    }
                    if (oid[1] > 79) {
                        oid[0] = 2;
                        oid[1] = oid[1] - 80;
                    } else {
                        oid[0] = oid[1] / 40;
                        oid[1] = oid[1] % 40;
                    }
                    this.next();
                    String str = null;
                    int tagTmp = this.tbs_tag;
                    this.tbs_offset += this.tbs_length;
                    switch (tagTmp) {
                        case 19: 
                        case 20: 
                        case 22: 
                        case 27: 
                        case 28: 
                        case 30: {
                            str = new String(this.tbs_buffer, this.tbs_contentOffset, this.tbs_length);
                            break;
                        }
                        case 12: {
                            str = new String(this.tbs_buffer, this.tbs_contentOffset, this.tbs_length, "UTF-8");
                            break;
                        }
                        default: {
                            byte[] encoded = new byte[this.tbs_offset - this.tbs_tagOffset];
                            System.arraycopy(this.tbs_buffer, this.tbs_tagOffset, encoded, 0, encoded.length);
                            str = this.toHexString(encoded);
                        }
                    }
                    rdn.add(new Object[]{this.mapOID(oid), this.makeCanonical(str)});
                }
                attributes.add(rdn);
                this.tbs_tagOffset = seqTagOffset2;
            }
            this.tbs_tagOffset = seqTagOffset;
            StringBuffer result = new StringBuffer();
            for (int i = attributes.size() - 1; i >= 0; --i) {
                rdn = (List)attributes.get(i);
                Collections.sort(rdn, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        return ((String)((Object[])obj1)[0]).compareTo((String)((Object[])obj2)[0]);
                    }
                });
                Iterator iter = rdn.iterator();
                while (iter.hasNext()) {
                    Object[] att = (Object[])iter.next();
                    result.append((String)att[0]);
                    result.append('=');
                    result.append((String)att[1]);
                    if (!iter.hasNext()) continue;
                    result.append('+');
                }
                if (i == 0) continue;
                result.append(',');
            }
            String string = result.toString().toLowerCase(Locale.US);
            return string;
        }
        finally {
            this.tbs_buffer = null;
        }
    }

    private void next() {
        this.tbs_tagOffset = this.tbs_offset;
        this.tbs_tag = this.tbs_buffer[this.tbs_offset++] & 0xFF;
        this.tbs_length = this.tbs_buffer[this.tbs_offset++] & 0xFF;
        if ((this.tbs_length & 0x80) != 0) {
            int numOctets = this.tbs_length & 0x7F;
            this.tbs_length = this.tbs_buffer[this.tbs_offset++] & 0xFF;
            for (int i = 1; i < numOctets; ++i) {
                int ch = this.tbs_buffer[this.tbs_offset++] & 0xFF;
                this.tbs_length = (this.tbs_length << 8) + ch;
            }
        }
        this.tbs_contentOffset = this.tbs_offset;
    }

    private String makeCanonical(String value) {
        int len = value.length();
        if (len == 0) {
            return value;
        }
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        if (value.charAt(0) == '#') {
            result.append('\\');
            result.append('#');
            ++i;
        }
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case ' ': {
                    int pos = result.length();
                    if (pos == 0 || result.charAt(pos - 1) == ' ') break;
                    result.append(' ');
                    break;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    result.append('\\');
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        for (i = result.length() - 1; i > -1 && result.charAt(i) == ' '; --i) {
        }
        result.setLength(i + 1);
        return result.toString();
    }

    private String toHexString(byte[] encoded) {
        StringBuffer result = new StringBuffer();
        result.append('#');
        for (int i = 0; i < encoded.length; ++i) {
            int c = encoded[i] >> 4 & 0xF;
            if (c < 10) {
                result.append((char)(c + 48));
            } else {
                result.append((char)(c + 87));
            }
            c = encoded[i] & 0xF;
            if (c < 10) {
                result.append((char)(c + 48));
                continue;
            }
            result.append((char)(c + 87));
        }
        return result.toString();
    }

    private String mapOID(int[] oid) {
        StringBuffer oidString = new StringBuffer();
        oidString.append(oid[0]);
        for (int i = 1; i < oid.length; ++i) {
            oidString.append('.');
            oidString.append(oid[i]);
        }
        String result = (String)OID2NAME.get(oidString.toString());
        if (result == null) {
            throw new IllegalArgumentException("Unknown oid: " + oidString.toString());
        }
        return result;
    }

    static {
        OID2NAME.put("2.5.4.3", "cn");
        OID2NAME.put("2.5.4.4", "sn");
        OID2NAME.put("2.5.4.6", "c");
        OID2NAME.put("2.5.4.7", "l");
        OID2NAME.put("2.5.4.8", "st");
        OID2NAME.put("2.5.4.10", "o");
        OID2NAME.put("2.5.4.11", "ou");
        OID2NAME.put("2.5.4.12", "title");
        OID2NAME.put("2.5.4.42", "givenname");
        OID2NAME.put("2.5.4.43", "initials");
        OID2NAME.put("2.5.4.44", "generationqualifier");
        OID2NAME.put("2.5.4.46", "dnqualifier");
        OID2NAME.put("2.5.4.9", "street");
        OID2NAME.put("0.9.2342.19200300.100.1.25", "dc");
        OID2NAME.put("0.9.2342.19200300.100.1.1", "uid");
        OID2NAME.put("1.2.840.113549.1.9.1", "emailaddress");
        OID2NAME.put("2.5.4.5", "serialnumber");
    }
}

