/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.ISearchPolicy;
import org.apache.felix.moduleloader.IURLPolicy;

public class ContentLoaderImpl
implements IContentLoader {
    private Logger m_logger = null;
    private IContent m_content = null;
    private IContent[] m_contentPath = null;
    private ISearchPolicy m_searchPolicy = null;
    private IURLPolicy m_urlPolicy = null;
    private ContentClassLoader m_classLoader = null;
    private ProtectionDomain m_protectionDomain = null;
    private static SecureAction m_secureAction = new SecureAction();

    public ContentLoaderImpl(Logger logger, IContent content, IContent[] contentPath) {
        this(logger, content, contentPath, null);
    }

    public ContentLoaderImpl(Logger logger, IContent content, IContent[] contentPath, ProtectionDomain protectionDomain) {
        this.m_logger = logger;
        this.m_content = content;
        this.m_contentPath = contentPath;
        this.m_protectionDomain = protectionDomain;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void open() {
        this.m_content.open();
        for (int i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            this.m_contentPath[i].open();
        }
    }

    public void close() {
        this.m_content.close();
        for (int i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            this.m_contentPath[i].close();
        }
    }

    public IContent getContent() {
        return this.m_content;
    }

    public IContent[] getClassPath() {
        return this.m_contentPath;
    }

    public void setSearchPolicy(ISearchPolicy searchPolicy) {
        this.m_searchPolicy = searchPolicy;
    }

    public ISearchPolicy getSearchPolicy() {
        return this.m_searchPolicy;
    }

    public void setURLPolicy(IURLPolicy urlPolicy) {
        this.m_urlPolicy = urlPolicy;
    }

    public IURLPolicy getURLPolicy() {
        return this.m_urlPolicy;
    }

    public Class getClass(String name) {
        if (this.m_classLoader == null) {
            this.m_classLoader = m_secureAction.createContentClassLoader(this, this.m_protectionDomain);
        }
        try {
            return this.m_classLoader.loadClassFromModule(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL url = null;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        for (int i = 0; url == null && i < this.getClassPath().length; ++i) {
            if (!this.getClassPath()[i].hasEntry(name)) continue;
            url = this.getURLPolicy().createURL(i + 1 + "/" + name);
        }
        return url;
    }

    public Enumeration getResources(String name) {
        Vector<URL> v = new Vector<URL>();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        for (int i = 0; i < this.getClassPath().length; ++i) {
            if (!this.getClassPath()[i].hasEntry(name)) continue;
            v.addElement(this.getURLPolicy().createURL(i + 1 + "/" + name));
        }
        return v.elements();
    }

    public URL getResourceFromContent(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.getURLPolicy().createURL("0/");
        }
        if (url == null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.getContent().hasEntry(name)) {
                url = this.getURLPolicy().createURL("0/" + name);
            }
        }
        return url;
    }

    public boolean hasInputStream(String urlPath) {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        int idx = Integer.parseInt(urlPath.substring(0, urlPath.indexOf(47)));
        urlPath = urlPath.substring(urlPath.indexOf(47) + 1);
        if (idx == 0) {
            return this.m_content.hasEntry(urlPath);
        }
        return this.m_contentPath[idx - 1].hasEntry(urlPath);
    }

    public InputStream getInputStream(String urlPath) throws IOException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        int idx = Integer.parseInt(urlPath.substring(0, urlPath.indexOf(47)));
        urlPath = urlPath.substring(urlPath.indexOf(47) + 1);
        if (idx == 0) {
            return this.m_content.getEntryAsStream(urlPath);
        }
        return this.m_contentPath[idx - 1].getEntryAsStream(urlPath);
    }

    public String toString() {
        return this.m_searchPolicy.toString();
    }
}

