/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.searchpolicy.R4Import;
import org.apache.felix.framework.searchpolicy.R4Library;
import org.apache.felix.framework.searchpolicy.R4Wire;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.ResolveListener;
import org.apache.felix.framework.util.PropertyResolver;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleFactory;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ModuleEvent;
import org.apache.felix.moduleloader.ModuleImpl;
import org.apache.felix.moduleloader.ModuleListener;
import org.apache.felix.moduleloader.ResourceNotFoundException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.Version;

public class R4SearchPolicyCore
implements ModuleListener {
    private Logger m_logger = null;
    private PropertyResolver m_config = null;
    private IModuleFactory m_factory = null;
    private Map m_availPkgMap = new HashMap();
    private Map m_inUsePkgMap = new HashMap();
    private Map m_moduleDataMap = new HashMap();
    private String[] m_bootPkgs = null;
    private boolean[] m_bootPkgWildcards = null;
    private static final ResolveListener[] m_emptyListeners = new ResolveListener[0];
    private ResolveListener[] m_listeners = m_emptyListeners;
    public static final IModule[] m_emptyModules = new IModule[0];
    private static SecurityManagerEx m_sm = new SecurityManagerEx();
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$R4SearchPolicyCore;
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$R4SearchPolicy;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public R4SearchPolicyCore(Logger logger, PropertyResolver config) {
        this.m_logger = logger;
        this.m_config = config;
        String s = this.m_config.get("org.osgi.framework.bootdelegation");
        s = s == null ? "java.*" : s + ",java.*";
        StringTokenizer st = new StringTokenizer(s, " ,");
        this.m_bootPkgs = new String[st.countTokens()];
        this.m_bootPkgWildcards = new boolean[this.m_bootPkgs.length];
        for (int i = 0; i < this.m_bootPkgs.length; ++i) {
            s = st.nextToken();
            if (s.endsWith("*")) {
                this.m_bootPkgWildcards[i] = true;
                s = s.substring(0, s.length() - 1);
            }
            this.m_bootPkgs[i] = s;
        }
    }

    public IModuleFactory getModuleFactory() {
        return this.m_factory;
    }

    public void setModuleFactory(IModuleFactory factory) throws IllegalStateException {
        if (this.m_factory != null) {
            throw new IllegalStateException("Module manager is already initialized");
        }
        this.m_factory = factory;
        this.m_factory.addModuleListener(this);
    }

    protected synchronized boolean isResolved(IModule module) {
        ModuleData data = (ModuleData)this.m_moduleDataMap.get(module);
        return data == null ? false : data.m_resolved;
    }

    protected synchronized void setResolved(IModule module, boolean resolved) {
        ModuleData data = (ModuleData)this.m_moduleDataMap.get(module);
        if (data == null) {
            data = new ModuleData(module);
            this.m_moduleDataMap.put(module, data);
        }
        data.m_resolved = resolved;
    }

    public Object[] definePackage(IModule module, String pkgName) {
        R4Export pkg = Util.getExportPackage(module, pkgName);
        if (pkg != null) {
            return new Object[]{pkgName, pkg.getVersion().toString(), "", "", "", ""};
        }
        return null;
    }

    public Class findClass(IModule module, String name) throws ClassNotFoundException {
        try {
            return (Class)this.findClassOrResource(module, name, true);
        }
        catch (ResourceNotFoundException ex) {
        }
        catch (ClassNotFoundException ex) {
            String msg = this.diagnoseClassLoadError(module, name);
            throw new ClassNotFoundException(msg, ex);
        }
        return null;
    }

    public URL findResource(IModule module, String name) throws ResourceNotFoundException {
        try {
            return (URL)this.findClassOrResource(module, name, false);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ResourceNotFoundException ex) {
            throw ex;
        }
        return null;
    }

    public Enumeration findResources(IModule module, String name) throws ResourceNotFoundException {
        Enumeration urls;
        try {
            this.resolve(module);
        }
        catch (ResolveException ex) {
            Enumeration urls2 = module.getContentLoader().getResources(name);
            if (urls2 != null) {
                return urls2;
            }
            throw new ResourceNotFoundException(name + ": cannot resolve package " + ex.getPackage());
        }
        String pkgName = Util.getResourcePackage(name);
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.m_bootPkgs.length; ++i) {
                if ((!this.m_bootPkgWildcards[i] || !pkgName.startsWith(this.m_bootPkgs[i]) && !this.m_bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.m_bootPkgWildcards[i] || !this.m_bootPkgs[i].equals(pkgName))) continue;
                try {
                    Enumeration<URL> urls3 = this.getClass().getClassLoader().getResources(name);
                    return urls3;
                }
                catch (IOException ex) {
                    return null;
                }
            }
        }
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            urls = wires[i].getResources(name);
            if (urls == null) continue;
            return urls;
        }
        urls = module.getContentLoader().getResources(name);
        if (urls != null) {
            return urls;
        }
        IWire wire = this.attemptDynamicImport(module, pkgName);
        if (wire != null) {
            urls = wire.getResources(name);
        }
        if (urls == null) {
            throw new ResourceNotFoundException(name);
        }
        return urls;
    }

    private Object findClassOrResource(IModule module, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        try {
            this.resolve(module);
        }
        catch (ResolveException ex) {
            if (isClass) {
                throw new ClassNotFoundException(name + ": cannot resolve package " + ex.getPackage());
            }
            URL url = module.getContentLoader().getResource(name);
            if (url != null) {
                return url;
            }
            throw new ResourceNotFoundException(name + ": cannot resolve package " + ex.getPackage());
        }
        String pkgName = isClass ? Util.getClassPackage(name) : Util.getResourcePackage(name);
        for (int i = 0; i < this.m_bootPkgs.length; ++i) {
            if (pkgName.length() <= 0 || (!this.m_bootPkgWildcards[i] || !pkgName.startsWith(this.m_bootPkgs[i]) && !this.m_bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.m_bootPkgWildcards[i] || !this.m_bootPkgs[i].equals(pkgName))) continue;
            return isClass ? this.getClass().getClassLoader().loadClass(name) : this.getClass().getClassLoader().getResource(name);
        }
        Object result = this.searchImports(module, name, isClass);
        if (result == null) {
            Object object = result = isClass ? module.getContentLoader().getClass(name) : module.getContentLoader().getResource(name);
            if (result == null) {
                result = this.searchDynamicImports(module, name, pkgName, isClass);
            }
        }
        if (result == null) {
            if (isClass) {
                throw new ClassNotFoundException(name);
            }
            throw new ResourceNotFoundException(name);
        }
        return result;
    }

    private Object searchImports(IModule module, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            Serializable result;
            Serializable serializable = result = isClass ? wires[i].getClass(name) : wires[i].getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Object searchDynamicImports(IModule module, String name, String pkgName, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire wire = this.attemptDynamicImport(module, pkgName);
        if (wire != null) {
            return isClass ? wire.getClass(name) : wire.getResource(name);
        }
        Class[] classes = m_sm.getClassContext();
        for (int i = 1; i < classes.length; ++i) {
            if ((class$org$apache$felix$framework$searchpolicy$R4SearchPolicyCore == null ? R4SearchPolicyCore.class$("org.apache.felix.framework.searchpolicy.R4SearchPolicyCore") : class$org$apache$felix$framework$searchpolicy$R4SearchPolicyCore).equals(classes[i]) || (class$org$apache$felix$framework$searchpolicy$R4SearchPolicy == null ? R4SearchPolicyCore.class$("org.apache.felix.framework.searchpolicy.R4SearchPolicy") : class$org$apache$felix$framework$searchpolicy$R4SearchPolicy).equals(classes[i]) || (class$java$lang$ClassLoader == null ? R4SearchPolicyCore.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader).isAssignableFrom(classes[i]) || (class$java$lang$Class == null ? R4SearchPolicyCore.class$("java.lang.Class") : class$java$lang$Class).isAssignableFrom(classes[i])) continue;
            if (ContentClassLoader.class.isInstance(classes[i].getClassLoader())) break;
            return this.getClass().getClassLoader().loadClass(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWire attemptDynamicImport(IModule module, String pkgName) {
        R4Wire wire = null;
        IModule candidate = null;
        try {
            R4Import impMatch = this.createDynamicImportTarget(module, pkgName);
            if (impMatch == null || Util.getWire(module, impMatch.getName()) != null) {
                return null;
            }
            IModuleFactory iModuleFactory = this.m_factory;
            synchronized (iModuleFactory) {
                IModule[] candidates = this.getInUseExporters(impMatch, false);
                if (candidates.length > 0) {
                    candidate = candidates[0];
                }
                if (candidate == null) {
                    candidates = this.getAvailableExporters(impMatch, false);
                    for (int candIdx = 0; candidate == null && candIdx < candidates.length; ++candIdx) {
                        try {
                            this.resolve(candidates[candIdx]);
                            candidate = candidates[candIdx];
                            continue;
                        }
                        catch (ResolveException ex) {
                            // empty catch block
                        }
                    }
                }
                if (candidate != null) {
                    IWire[] wires = module.getWires();
                    IWire[] newWires = null;
                    if (wires == null) {
                        newWires = new R4Wire[1];
                    } else {
                        newWires = new R4Wire[wires.length + 1];
                        System.arraycopy(wires, 0, newWires, 0, wires.length);
                    }
                    newWires[newWires.length - 1] = wire = new R4Wire(module, candidate, Util.getExportPackage(candidate, impMatch.getName()));
                    ((ModuleImpl)module).setWires(newWires);
                    this.m_logger.log(4, "WIRE: " + newWires[newWires.length - 1]);
                }
            }
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Unable to dynamically import package.", ex);
        }
        return wire;
    }

    private R4Import createDynamicImportTarget(IModule module, String pkgName) {
        R4Import[] dynamics = module.getDefinition().getDynamicImports();
        R4Import impMatch = null;
        for (int i = 0; impMatch == null && dynamics != null && i < dynamics.length; ++i) {
            if (dynamics[i].getName().equals("*")) {
                impMatch = new R4Import(pkgName, dynamics[i].getDirectives(), dynamics[i].getAttributes());
                continue;
            }
            if (dynamics[i].getName().endsWith(".*")) {
                if (!pkgName.regionMatches(0, dynamics[i].getName(), 0, dynamics[i].getName().length() - 2)) continue;
                impMatch = new R4Import(pkgName, dynamics[i].getDirectives(), dynamics[i].getAttributes());
                continue;
            }
            if (!pkgName.equals(dynamics[i].getName())) continue;
            impMatch = dynamics[i];
        }
        return impMatch;
    }

    public String findLibrary(IModule module, String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        R4Library[] libs = module.getDefinition().getLibraries();
        for (int i = 0; libs != null && i < libs.length; ++i) {
            String lib = libs[i].getPath(name);
            if (lib == null) continue;
            return lib;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModule[] getAvailableExporters(R4Import pkg, boolean includeRemovalPending) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IModule[] exporters = this.getCompatibleExporters((IModule[])this.m_availPkgMap.get(pkg.getName()), pkg, includeRemovalPending);
            if (exporters != null && System.getSecurityManager() != null) {
                PackagePermission perm = new PackagePermission(pkg.getName(), "export");
                for (int i = 0; i < exporters.length; ++i) {
                    if (exporters[i] == null || ((ProtectionDomain)exporters[i].getSecurityContext()).implies(perm)) continue;
                    this.m_logger.log(4, "PackagePermission.EXPORT denied for " + pkg + "from " + exporters[i].getId());
                    exporters[i] = null;
                }
                exporters = R4SearchPolicyCore.shrinkModuleArray(exporters);
            }
            return exporters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModule[] getInUseExporters(R4Import pkg, boolean includeRemovalPending) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            return this.getCompatibleExporters((IModule[])this.m_inUsePkgMap.get(pkg.getName()), pkg, includeRemovalPending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(IModule rootModule) throws ResolveException {
        if (this.isResolved(rootModule)) {
            return;
        }
        HashMap resolverMap = new HashMap();
        Map resolvedModuleWireMap = null;
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            this.populateResolverMap(resolverMap, rootModule);
            this.findConsistentClassSpace(resolverMap, rootModule);
            resolvedModuleWireMap = this.createWires(resolverMap, rootModule);
        }
        if (resolvedModuleWireMap != null) {
            Iterator iter = resolvedModuleWireMap.entrySet().iterator();
            while (iter.hasNext()) {
                this.fireModuleResolved((IModule)iter.next().getKey());
            }
        }
    }

    private void populateResolverMap(Map resolverMap, IModule module) throws ResolveException {
        if (resolverMap.get(module) != null) {
            return;
        }
        ArrayList<ResolverNode> nodeList = new ArrayList<ResolverNode>();
        resolverMap.put(module, nodeList);
        R4Import[] imports = module.getDefinition().getImports();
        for (int impIdx = 0; imports != null && impIdx < imports.length; ++impIdx) {
            IModule[] inuse = this.getInUseExporters(imports[impIdx], false);
            IModule[] available = this.getAvailableExporters(imports[impIdx], false);
            IModule[] candidates = new IModule[inuse.length + available.length];
            System.arraycopy(inuse, 0, candidates, 0, inuse.length);
            System.arraycopy(available, 0, candidates, inuse.length, available.length);
            ResolveException rethrow = null;
            if (candidates.length > 0) {
                for (int candIdx = 0; candIdx < candidates.length; ++candIdx) {
                    try {
                        if (this.isResolved(candidates[candIdx])) continue;
                        this.populateResolverMap(resolverMap, candidates[candIdx]);
                        continue;
                    }
                    catch (ResolveException ex) {
                        candidates[candIdx] = null;
                        rethrow = ex;
                    }
                }
                candidates = R4SearchPolicyCore.shrinkModuleArray(candidates);
            }
            if (candidates.length == 0 && !imports[impIdx].isOptional()) {
                resolverMap.remove(module);
                if (rethrow != null) {
                    throw rethrow;
                }
                throw new ResolveException("Unable to resolve.", module, imports[impIdx]);
            }
            if (candidates.length <= 0) continue;
            nodeList.add(new ResolverNode(module, imports[impIdx], candidates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAvailablePackages() {
        R4SearchPolicyCore r4SearchPolicyCore = this;
        synchronized (r4SearchPolicyCore) {
            System.out.println("AVAILABLE PACKAGES:");
            Iterator i = this.m_availPkgMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IModule[] modules = (IModule[])entry.getValue();
                if (modules == null || modules.length <= 0) continue;
                System.out.println("  " + entry.getKey());
                for (int j = 0; j < modules.length; ++j) {
                    System.out.println("    " + modules[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUsedPackages() {
        R4SearchPolicyCore r4SearchPolicyCore = this;
        synchronized (r4SearchPolicyCore) {
            System.out.println("USED PACKAGES:");
            Iterator i = this.m_inUsePkgMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IModule[] modules = (IModule[])entry.getValue();
                if (modules == null || modules.length <= 0) continue;
                System.out.println("  " + entry.getKey());
                for (int j = 0; j < modules.length; ++j) {
                    System.out.println("    " + modules[j]);
                }
            }
        }
    }

    private IModule[] getCompatibleExporters(IModule[] modules, R4Import target, boolean includeRemovalPending) {
        IModule[] candidates = null;
        for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
            R4Export export;
            if (!includeRemovalPending && modules[modIdx].isRemovalPending() || (export = Util.getExportPackage(modules[modIdx], target.getName())) == null || !target.isSatisfied(export)) continue;
            candidates = R4SearchPolicyCore.addModuleToArray(candidates, modules[modIdx]);
        }
        if (candidates == null) {
            return m_emptyModules;
        }
        return candidates;
    }

    private void findConsistentClassSpace(Map resolverMap, IModule rootModule) throws ResolveException {
        ArrayList<List> resolverList = null;
        HashMap cycleMap = new HashMap();
        while (!this.isClassSpaceConsistent(resolverMap, rootModule, cycleMap)) {
            this.m_logger.log(4, "Constraint violation detected, will try to repair.");
            if (resolverList == null) {
                resolverList = new ArrayList<List>();
                Iterator iter = resolverMap.entrySet().iterator();
                while (iter.hasNext()) {
                    resolverList.add((List)iter.next().getValue());
                }
            }
            this.incrementCandidateConfiguration(resolverList);
            cycleMap.clear();
        }
    }

    private boolean isClassSpaceConsistent(Map resolverMap, IModule rootModule, Map cycleMap) {
        if (this.isResolved(rootModule) || cycleMap.get(rootModule) != null) {
            return true;
        }
        cycleMap.put(rootModule, rootModule);
        R4Export[] exports = rootModule.getDefinition().getExports();
        HashMap<String, IModule> usesMap = new HashMap<String, IModule>();
        for (int i = 0; exports != null && i < exports.length; ++i) {
            if (Util.getImportPackage(rootModule, exports[i].getName()) != null) continue;
            usesMap.put(exports[i].getName(), rootModule);
        }
        List nodeList = (List)resolverMap.get(rootModule);
        for (int nodeIdx = 0; nodeIdx < nodeList.size(); ++nodeIdx) {
            ResolverNode node = (ResolverNode)nodeList.get(nodeIdx);
            if (!this.isClassSpaceConsistent(resolverMap, node.m_candidates[node.m_idx], cycleMap)) {
                return false;
            }
            R4Export candidatePkg = Util.getExportPackage(node.m_candidates[node.m_idx], node.m_import.getName());
            Map candUsesMap = this.calculateUsesDependencies(resolverMap, node.m_candidates[node.m_idx], candidatePkg, new HashMap());
            Iterator usesIter = candUsesMap.entrySet().iterator();
            while (usesIter.hasNext()) {
                Map.Entry entry = usesIter.next();
                if (usesMap.get(entry.getKey()) == null || usesMap.get(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
            usesMap.putAll(candUsesMap);
        }
        return true;
    }

    private Map calculateUsesDependencies(Map resolverMap, IModule module, R4Export export, Map usesMap) {
        if (usesMap.get(export.getName()) != null) {
            return usesMap;
        }
        usesMap.put(export.getName(), module);
        String[] uses = export.getUses();
        List nodeList = (List)resolverMap.get(module);
        for (int usesIdx = 0; usesIdx < uses.length; ++usesIdx) {
            if (nodeList == null) {
                IWire wire = Util.getWire(module, uses[usesIdx]);
                if (wire != null) {
                    usesMap = this.calculateUsesDependencies(resolverMap, wire.getExporter(), wire.getExport(), usesMap);
                    continue;
                }
                export = Util.getExportPackage(module, uses[usesIdx]);
                if (export == null) continue;
                usesMap = this.calculateUsesDependencies(resolverMap, module, export, usesMap);
                continue;
            }
            ResolverNode node = null;
            for (int nodeIdx = 0; node == null && nodeIdx < nodeList.size(); ++nodeIdx) {
                node = (ResolverNode)nodeList.get(nodeIdx);
                if (node.m_import.getName().equals(uses[usesIdx])) continue;
                node = null;
            }
            if (node != null) {
                usesMap = this.calculateUsesDependencies(resolverMap, node.m_candidates[node.m_idx], Util.getExportPackage(node.m_candidates[node.m_idx], node.m_import.getName()), usesMap);
                continue;
            }
            if (Util.getExportPackage(module, uses[usesIdx]) == null) continue;
            usesMap = this.calculateUsesDependencies(resolverMap, module, Util.getExportPackage(module, uses[usesIdx]), usesMap);
        }
        return usesMap;
    }

    private void incrementCandidateConfiguration(List resolverList) throws ResolveException {
        for (int i = 0; i < resolverList.size(); ++i) {
            List nodeList = (List)resolverList.get(i);
            for (int j = 0; j < nodeList.size(); ++j) {
                ResolverNode node = (ResolverNode)nodeList.get(j);
                if (node.m_idx + 1 < node.m_candidates.length) {
                    ++node.m_idx;
                    return;
                }
                node.m_idx = 0;
            }
        }
        throw new ResolveException("Unable to resolve due to constraint violation.", null, null);
    }

    private Map createWires(Map resolverMap, IModule rootModule) {
        Map resolvedModuleWireMap = this.populateWireMap(resolverMap, rootModule, new HashMap());
        Iterator iter = resolvedModuleWireMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IModule module = (IModule)entry.getKey();
            IWire[] wires = (IWire[])entry.getValue();
            this.setResolved(module, true);
            if (wires.length > 0) {
                ((ModuleImpl)module).setWires(wires);
            }
            for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
                this.m_logger.log(4, "WIRE: " + wires[wireIdx]);
                IModule[] modules = (IModule[])this.m_availPkgMap.get(wires[wireIdx].getExport().getName());
                modules = R4SearchPolicyCore.removeModuleFromArray(modules, wires[wireIdx].getExporter());
                this.m_availPkgMap.put(wires[wireIdx].getExport().getName(), modules);
                if (wires[wireIdx].getExporter() != module) {
                    modules = (IModule[])this.m_availPkgMap.get(wires[wireIdx].getExport().getName());
                    modules = R4SearchPolicyCore.removeModuleFromArray(modules, module);
                    this.m_availPkgMap.put(wires[wireIdx].getExport().getName(), modules);
                }
                modules = (IModule[])this.m_inUsePkgMap.get(wires[wireIdx].getExport().getName());
                modules = R4SearchPolicyCore.addModuleToArray(modules, wires[wireIdx].getExporter());
                this.m_inUsePkgMap.put(wires[wireIdx].getExport().getName(), modules);
            }
        }
        return resolvedModuleWireMap;
    }

    private Map populateWireMap(Map resolverMap, IModule module, Map wireMap) {
        if (this.isResolved(module) || wireMap.get(module) != null) {
            return wireMap;
        }
        List nodeList = (List)resolverMap.get(module);
        IWire[] wires = new IWire[nodeList.size()];
        wireMap.put(module, wires);
        for (int nodeIdx = 0; nodeIdx < nodeList.size(); ++nodeIdx) {
            ResolverNode node = (ResolverNode)nodeList.get(nodeIdx);
            R4Export export = Util.getExportPackage(node.m_candidates[node.m_idx], node.m_import.getName());
            wires[nodeIdx] = new R4Wire(module, node.m_candidates[node.m_idx], export);
            wireMap = this.populateWireMap(resolverMap, node.m_candidates[node.m_idx], wireMap);
        }
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResolverListener(ResolveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ResolveListener[] resolveListenerArray = m_emptyListeners;
        synchronized (m_emptyListeners) {
            if (this.m_listeners == m_emptyListeners) {
                this.m_listeners = new ResolveListener[]{l};
            } else {
                ResolveListener[] newList = new ResolveListener[this.m_listeners.length + 1];
                System.arraycopy(this.m_listeners, 0, newList, 0, this.m_listeners.length);
                newList[this.m_listeners.length] = l;
                this.m_listeners = newList;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResolverListener(ResolveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ResolveListener[] resolveListenerArray = m_emptyListeners;
        synchronized (m_emptyListeners) {
            int idx = -1;
            for (int i = 0; i < this.m_listeners.length; ++i) {
                if (!this.m_listeners[i].equals(l)) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (this.m_listeners.length == 1) {
                    this.m_listeners = m_emptyListeners;
                } else {
                    ResolveListener[] newList = new ResolveListener[this.m_listeners.length - 1];
                    System.arraycopy(this.m_listeners, 0, newList, 0, idx);
                    if (idx < newList.length) {
                        System.arraycopy(this.m_listeners, idx + 1, newList, idx, newList.length - idx);
                    }
                    this.m_listeners = newList;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void fireModuleResolved(IModule module) {
        ModuleEvent event = null;
        ResolveListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this.m_factory, module);
            }
            listeners[i].moduleResolved(event);
        }
    }

    private void fireModuleUnresolved(IModule module) {
        ModuleEvent event = null;
        ResolveListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this.m_factory, module);
            }
            listeners[i].moduleUnresolved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleAdded(ModuleEvent event) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IModule module = event.getModule();
            R4Export[] exports = module.getDefinition().getExports();
            for (int i = 0; exports != null && i < exports.length; ++i) {
                IModule[] modules = (IModule[])this.m_availPkgMap.get(exports[i].getName());
                if (modules == null) {
                    modules = new IModule[]{module};
                } else {
                    int top = 0;
                    int bottom = modules.length - 1;
                    int middle = 0;
                    Version middleVersion = null;
                    while (top <= bottom) {
                        middle = (bottom - top) / 2 + top;
                        middleVersion = Util.getExportPackage(modules[middle], exports[i].getName()).getVersion();
                        int cmp = middleVersion.compareTo(exports[i].getVersion());
                        if (cmp < 0) {
                            bottom = middle - 1;
                            continue;
                        }
                        if (cmp == 0) {
                            long exportId;
                            long middleId = Util.getBundleIdFromModuleId(modules[middle].getId());
                            if (middleId < (exportId = Util.getBundleIdFromModuleId(module.getId()))) {
                                top = middle + 1;
                                continue;
                            }
                            bottom = middle - 1;
                            continue;
                        }
                        top = middle + 1;
                    }
                    IModule[] newMods = new IModule[modules.length + 1];
                    System.arraycopy(modules, 0, newMods, 0, top);
                    System.arraycopy(modules, top, newMods, top + 1, modules.length - top);
                    newMods[top] = module;
                    modules = newMods;
                }
                this.m_availPkgMap.put(exports[i].getName(), modules);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleRemoved(ModuleEvent event) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            R4Export[] exports = event.getModule().getDefinition().getExports();
            for (int i = 0; exports != null && i < exports.length; ++i) {
                IModule[] modules = (IModule[])this.m_availPkgMap.get(exports[i].getName());
                if (modules != null) {
                    modules = R4SearchPolicyCore.removeModuleFromArray(modules, event.getModule());
                    this.m_availPkgMap.put(exports[i].getName(), modules);
                }
                if ((modules = (IModule[])this.m_inUsePkgMap.get(exports[i].getName())) == null) continue;
                modules = R4SearchPolicyCore.removeModuleFromArray(modules, event.getModule());
                this.m_inUsePkgMap.put(exports[i].getName(), modules);
            }
            this.m_moduleDataMap.remove(event.getModule());
        }
    }

    private static IModule[] addModuleToArray(IModule[] modules, IModule m) {
        for (int i = 0; modules != null && i < modules.length; ++i) {
            if (modules[i] != m) continue;
            return modules;
        }
        if (modules != null) {
            IModule[] newModules = new IModule[modules.length + 1];
            System.arraycopy(modules, 0, newModules, 0, modules.length);
            newModules[modules.length] = m;
            modules = newModules;
        } else {
            modules = new IModule[]{m};
        }
        return modules;
    }

    private static IModule[] removeModuleFromArray(IModule[] modules, IModule m) {
        if (modules == null) {
            return m_emptyModules;
        }
        int idx = -1;
        for (int i = 0; i < modules.length; ++i) {
            if (modules[i] != m) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (modules.length - 1 == 0) {
                modules = m_emptyModules;
            } else {
                IModule[] newModules = new IModule[modules.length - 1];
                System.arraycopy(modules, 0, newModules, 0, idx);
                if (idx < newModules.length) {
                    System.arraycopy(modules, idx + 1, newModules, idx, newModules.length - idx);
                }
                modules = newModules;
            }
        }
        return modules;
    }

    private static IModule[] shrinkModuleArray(IModule[] modules) {
        if (modules == null) {
            return m_emptyModules;
        }
        int lower = 0;
        for (int i = 0; i < modules.length; ++i) {
            if (modules[i] == null) continue;
            modules[lower++] = modules[i];
        }
        if (lower == 0) {
            return m_emptyModules;
        }
        IModule[] newModules = new IModule[lower];
        System.arraycopy(modules, 0, newModules, 0, lower);
        return newModules;
    }

    private String diagnoseClassLoadError(IModule module, String name) {
        String pkgName = Util.getClassPackage(name);
        long impId = Util.getBundleIdFromModuleId(module.getId());
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getExport().getName().equals(pkgName)) continue;
            long expId = Util.getBundleIdFromModuleId(wires[i].getExporter().getId());
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is imported by bundle ");
            sb.append(impId);
            sb.append(" from bundle ");
            sb.append(expId);
            sb.append(", but the exported package from bundle ");
            sb.append(expId);
            sb.append(" does not contain the requested class '");
            sb.append(name);
            sb.append("'. Please verify that the class name is correct in the importing bundle ");
            sb.append(impId);
            sb.append(" and/or that the exported package is correctly bundled in ");
            sb.append(expId);
            sb.append(". ***");
            return sb.toString();
        }
        R4Import[] imports = module.getDefinition().getImports();
        for (int i = 0; imports != null && i < imports.length; ++i) {
            if (!imports[i].getName().equals(pkgName) || !imports[i].isOptional()) continue;
            IModule[] exporters = this.getInUseExporters(imports[i], true);
            exporters = exporters.length == 0 ? this.getAvailableExporters(imports[i], true) : exporters;
            exporters = exporters.length == 0 ? this.getInUseExporters(new R4Import(pkgName, null, null), true) : exporters;
            exporters = exporters.length == 0 ? this.getAvailableExporters(new R4Import(pkgName, null, null), true) : exporters;
            long expId = exporters.length == 0 ? -1L : Util.getBundleIdFromModuleId(exporters[0].getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found, but this is likely normal since package '");
            sb.append(pkgName);
            sb.append("' is optionally imported by bundle ");
            sb.append(impId);
            sb.append(".");
            if (exporters.length > 0) {
                sb.append(" However, bundle ");
                sb.append(expId);
                if (imports[i].isSatisfied(Util.getExportPackage(exporters[0], imports[i].getName()))) {
                    sb.append(" does export this package. Bundle ");
                    sb.append(expId);
                    sb.append(" must be installed before bundle ");
                    sb.append(impId);
                    sb.append(" is resolved or else the optional import will be ignored.");
                } else {
                    sb.append(" does export this package with attributes that do not match.");
                }
            }
            sb.append(" ***");
            return sb.toString();
        }
        R4Import imp = this.createDynamicImportTarget(module, pkgName);
        if (imp != null) {
            IModule[] exporters = this.getInUseExporters(imp, true);
            exporters = exporters.length == 0 ? this.getAvailableExporters(imp, true) : exporters;
            exporters = exporters.length == 0 ? this.getInUseExporters(new R4Import(pkgName, null, null), true) : exporters;
            exporters = exporters.length == 0 ? this.getAvailableExporters(new R4Import(pkgName, null, null), true) : exporters;
            long expId = exporters.length == 0 ? -1L : Util.getBundleIdFromModuleId(exporters[0].getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found, but this is likely normal since package '");
            sb.append(pkgName);
            sb.append("' is dynamically imported by bundle ");
            sb.append(impId);
            sb.append(".");
            if (exporters.length > 0 && !imp.isSatisfied(Util.getExportPackage(exporters[0], imp.getName()))) {
                sb.append(" However, bundle ");
                sb.append(expId);
                sb.append(" does export this package with attributes that do not match.");
            }
            sb.append(" ***");
            return sb.toString();
        }
        IModule[] exporters = this.getInUseExporters(new R4Import(pkgName, null, null), true);
        IModule[] iModuleArray = exporters = exporters.length == 0 ? this.getAvailableExporters(new R4Import(pkgName, null, null), true) : exporters;
        if (exporters.length > 0) {
            boolean classpath = false;
            try {
                this.getClass().getClassLoader().loadClass(name);
                classpath = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            long expId = Util.getBundleIdFromModuleId(exporters[0].getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found because bundle ");
            sb.append(impId);
            sb.append(" does not import '");
            sb.append(pkgName);
            sb.append("' even though bundle ");
            sb.append(expId);
            sb.append(" does export it.");
            if (classpath) {
                sb.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                sb.append("2) Add package '");
                sb.append(pkgName);
                sb.append("' to the '");
                sb.append("org.osgi.framework.bootdelegation");
                sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                sb.append(" To resolve this issue, add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append(".");
            }
            sb.append(" ***");
            return sb.toString();
        }
        try {
            this.getClass().getClassLoader().loadClass(name);
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is not imported by bundle ");
            sb.append(impId);
            sb.append(", nor is there any bundle that exports package '");
            sb.append(pkgName);
            sb.append("'. However, the class '");
            sb.append(name);
            sb.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.system.packages");
            sb.append("' property and modify bundle ");
            sb.append(impId);
            sb.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.bootdelegation");
            sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            sb.append(" ***");
            return sb.toString();
        }
        catch (Exception ex2) {
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found. Bundle ");
            sb.append(impId);
            sb.append(" does not import package '");
            sb.append(pkgName);
            sb.append("', nor is the package exported by any other bundle or available from the system class loader.");
            sb.append(" ***");
            return sb.toString();
        }
    }

    private class ResolverNode {
        public IModule m_module = null;
        public R4Import m_import = null;
        public IModule[] m_candidates = null;
        public int m_idx = 0;
        public boolean m_visited = false;

        public ResolverNode(IModule module, R4Import imp, IModule[] candidates) {
            this.m_module = module;
            this.m_import = imp;
            this.m_candidates = candidates;
            if (R4SearchPolicyCore.this.isResolved(this.m_module)) {
                this.m_visited = true;
            }
        }
    }

    private static class ModuleData {
        public IModule m_module = null;
        public boolean m_resolved = false;

        public ModuleData(IModule module) {
            this.m_module = module;
        }
    }
}

