/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.searchpolicy.R4Attribute;
import org.apache.felix.framework.searchpolicy.R4Directive;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.searchpolicy.R4Import;
import org.apache.felix.framework.searchpolicy.R4Library;
import org.apache.felix.framework.searchpolicy.R4LibraryClause;
import org.apache.felix.framework.searchpolicy.R4Package;
import org.apache.felix.framework.searchpolicy.VersionRange;
import org.apache.felix.framework.util.PropertyResolver;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class ManifestParser {
    private Logger m_logger = null;
    private PropertyResolver m_config = null;
    private Map m_headerMap = null;
    private String m_bundleSymbolicName = null;
    private Version m_bundleVersion = null;
    private R4Export[] m_exports = null;
    private R4Import[] m_imports = null;
    private R4Import[] m_dynamics = null;
    private R4LibraryClause[] m_libraryHeaders = null;
    private boolean m_libraryHeadersOptional = false;
    public static final int CLAUSE_PATHS_INDEX = 0;
    public static final int CLAUSE_DIRECTIVES_INDEX = 1;
    public static final int CLAUSE_ATTRIBUTES_INDEX = 2;

    public ManifestParser(Logger logger, PropertyResolver config, Map headerMap) throws BundleException {
        int pkgIdx;
        this.m_logger = logger;
        this.m_config = config;
        this.m_headerMap = headerMap;
        String manifestVersion = (String)this.m_headerMap.get("Bundle-ManifestVersion");
        if (manifestVersion != null && !manifestVersion.equals("2")) {
            throw new BundleException("Unknown 'Bundle-ManifestVersion' value: " + manifestVersion);
        }
        if (this.m_headerMap.get("Bundle-Version") != null) {
            try {
                this.m_bundleVersion = Version.parseVersion((String)this.m_headerMap.get("Bundle-Version"));
            }
            catch (RuntimeException ex) {
                if (this.getManifestVersion().equals("2")) {
                    throw ex;
                }
                this.m_bundleVersion = Version.emptyVersion;
            }
        }
        HashMap<String, R4Package> dupeMap = new HashMap<String, R4Package>();
        Object[][][] clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Bundle-SymbolicName"));
        if (clauses.length > 0) {
            if (clauses.length > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            if (clauses[0][0].length > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            this.m_bundleSymbolicName = (String)clauses[0][0][0];
        }
        R4Package[] pkgs = ManifestParser.parseImportExportHeader((String)headerMap.get("Export-Package"));
        dupeMap.clear();
        for (pkgIdx = 0; pkgIdx < pkgs.length; ++pkgIdx) {
            if (dupeMap.get(pkgs[pkgIdx].getName()) == null) {
                if (pkgs[pkgIdx].getName().startsWith("java.")) {
                    throw new BundleException("Exporting java.* packages not allowed: " + pkgs[pkgIdx].getName());
                }
                dupeMap.put(pkgs[pkgIdx].getName(), new R4Export(pkgs[pkgIdx]));
                continue;
            }
            this.m_logger.log(2, "Duplicate export - " + pkgs[pkgIdx].getName());
        }
        this.m_exports = dupeMap.values().toArray(new R4Export[dupeMap.size()]);
        clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Require-Bundle"));
        if (clauses.length > 0) {
            for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
                for (int pathIdx = 0; pathIdx < clauses[clauseIdx][0].length; ++pathIdx) {
                }
            }
        }
        pkgs = ManifestParser.parseImportExportHeader((String)headerMap.get("Import-Package"));
        dupeMap.clear();
        for (pkgIdx = 0; pkgIdx < pkgs.length; ++pkgIdx) {
            if (dupeMap.get(pkgs[pkgIdx].getName()) == null) {
                if (pkgs[pkgIdx].getName().startsWith("java.")) {
                    throw new BundleException("Importing java.* packages not allowed: " + pkgs[pkgIdx].getName());
                }
            } else {
                throw new BundleException("Duplicate import - " + pkgs[pkgIdx].getName());
            }
            dupeMap.put(pkgs[pkgIdx].getName(), new R4Import(pkgs[pkgIdx]));
        }
        this.m_imports = dupeMap.values().toArray(new R4Import[dupeMap.size()]);
        pkgs = ManifestParser.parseImportExportHeader((String)headerMap.get("DynamicImport-Package"));
        ArrayList<R4Import> dynList = new ArrayList<R4Import>();
        for (int pkgIdx2 = 0; pkgIdx2 < pkgs.length; ++pkgIdx2) {
            if (pkgs[pkgIdx2].getName().startsWith("java.")) {
                throw new BundleException("Dynamically importing java.* packages not allowed: " + pkgs[pkgIdx2].getName());
            }
            dynList.add(new R4Import(pkgs[pkgIdx2]));
        }
        this.m_dynamics = dynList.toArray(new R4Import[dynList.size()]);
        this.m_libraryHeaders = Util.parseLibraryStrings(this.m_logger, Util.parseDelimitedString((String)this.m_headerMap.get("Bundle-NativeCode"), ","));
        if (this.m_libraryHeaders.length > 0 && this.m_libraryHeaders[this.m_libraryHeaders.length - 1].getLibraryFiles() == null) {
            this.m_libraryHeadersOptional = true;
            R4LibraryClause[] tmp = new R4LibraryClause[this.m_libraryHeaders.length - 1];
            System.arraycopy(this.m_libraryHeaders, 0, tmp, 0, this.m_libraryHeaders.length - 1);
            this.m_libraryHeaders = tmp;
        }
        if (this.getManifestVersion().equals("2")) {
            this.checkAndNormalizeR4();
        } else {
            this.checkAndNormalizeR3();
        }
    }

    public String getManifestVersion() {
        String manifestVersion = (String)this.m_headerMap.get("Bundle-ManifestVersion");
        return manifestVersion == null ? "1" : manifestVersion;
    }

    public String getSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public Version getBundleVersion() {
        return this.m_bundleVersion;
    }

    public R4Export[] getExports() {
        return this.m_exports;
    }

    public R4Import[] getImports() {
        return this.m_imports;
    }

    public R4Import[] getDynamicImports() {
        return this.m_dynamics;
    }

    public R4LibraryClause[] getLibraryClauses() {
        return this.m_libraryHeaders;
    }

    public R4Library[] getLibraries(BundleRevision revision) throws BundleException {
        R4LibraryClause clause = this.getSelectedLibraryClause();
        if (clause != null) {
            R4Library[] libraries = new R4Library[clause.getLibraryFiles().length];
            for (int i = 0; i < libraries.length; ++i) {
                libraries[i] = new R4Library(this.m_logger, revision, clause.getLibraryFiles()[i], clause.getOSNames(), clause.getProcessors(), clause.getOSVersions(), clause.getLanguages(), clause.getSelectionFilter());
            }
            return libraries;
        }
        return null;
    }

    private R4LibraryClause getSelectedLibraryClause() throws BundleException {
        if (this.m_libraryHeaders != null && this.m_libraryHeaders.length > 0) {
            ArrayList<R4LibraryClause> clauseList = new ArrayList<R4LibraryClause>();
            for (int i = 0; i < this.m_libraryHeaders.length; ++i) {
                if (!this.m_libraryHeaders[i].match(this.m_config)) continue;
                clauseList.add(this.m_libraryHeaders[i]);
            }
            int selected = 0;
            if (clauseList.size() == 0) {
                if (this.m_libraryHeadersOptional) {
                    return null;
                }
                throw new BundleException("Unable to select a native library clause.");
            }
            if (clauseList.size() == 1) {
                selected = 0;
            } else if (clauseList.size() > 1) {
                selected = this.firstSortedClause(clauseList);
            }
            return (R4LibraryClause)clauseList.get(selected);
        }
        return null;
    }

    private int firstSortedClause(List clauseList) {
        VersionRange range;
        int k;
        String[] osversions;
        int index;
        int i;
        ArrayList<String> indexList = new ArrayList<String>();
        ArrayList<String> selection = new ArrayList<String>();
        for (int i2 = 0; i2 < clauseList.size(); ++i2) {
            indexList.add("" + i2);
        }
        Version osVersionRangeMaxFloor = new Version(0, 0, 0);
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
            if (osversions != null) {
                selection.add("" + indexList.get(i));
            }
            for (k = 0; osversions != null && k < osversions.length; ++k) {
                range = VersionRange.parse(osversions[k]);
                if (range.getLow().compareTo(osVersionRangeMaxFloor) < 0) continue;
                osVersionRangeMaxFloor = range.getLow();
            }
        }
        if (selection.size() == 1) {
            return Integer.parseInt(selection.get(0).toString());
        }
        if (selection.size() > 1) {
            indexList = selection;
            selection = new ArrayList();
            for (i = 0; i < indexList.size(); ++i) {
                index = Integer.parseInt(indexList.get(i).toString());
                osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
                for (k = 0; k < osversions.length; ++k) {
                    range = VersionRange.parse(osversions[k]);
                    if (range.getLow().compareTo(osVersionRangeMaxFloor) < 0) continue;
                    selection.add("" + indexList.get(i));
                }
            }
        }
        if (selection.size() == 0) {
            selection.clear();
            indexList.clear();
            for (i = 0; i < clauseList.size(); ++i) {
                indexList.add("" + i);
            }
        } else {
            if (selection.size() == 1) {
                return Integer.parseInt(selection.get(0).toString());
            }
            indexList = selection;
            selection.clear();
        }
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            if (((R4LibraryClause)clauseList.get(index)).getLanguages() == null) continue;
            selection.add("" + indexList.get(i));
        }
        if (selection.size() == 0) {
            return 0;
        }
        return Integer.parseInt(selection.get(0).toString());
    }

    private void checkAndNormalizeR3() throws BundleException {
        int i;
        int i2;
        int attrIdx;
        R4Attribute versionAttr;
        for (int expIdx = 0; this.m_exports != null && expIdx < this.m_exports.length; ++expIdx) {
            if (this.m_exports[expIdx].getDirectives().length != 0) {
                throw new BundleException("R3 exports cannot contain directives.");
            }
            if (this.m_exports[expIdx].getAttributes() == null) continue;
            versionAttr = null;
            for (attrIdx = 0; attrIdx < this.m_exports[expIdx].getAttributes().length; ++attrIdx) {
                if (this.m_exports[expIdx].getAttributes()[attrIdx].getName().equals("version")) {
                    versionAttr = this.m_exports[expIdx].getAttributes()[attrIdx];
                    continue;
                }
                this.m_logger.log(2, "Unknown R3 export attribute: " + this.m_exports[expIdx].getAttributes()[attrIdx].getName());
            }
            if (versionAttr != null && this.m_exports[expIdx].getAttributes().length > 1) {
                this.m_exports[expIdx] = new R4Export(this.m_exports[expIdx].getName(), null, new R4Attribute[]{versionAttr});
                continue;
            }
            if (versionAttr != null || this.m_exports[expIdx].getAttributes().length <= 0) continue;
            this.m_exports[expIdx] = new R4Export(this.m_exports[expIdx].getName(), null, null);
        }
        for (int impIdx = 0; this.m_imports != null && impIdx < this.m_imports.length; ++impIdx) {
            if (this.m_imports[impIdx].getDirectives().length != 0) {
                throw new BundleException("R3 imports cannot contain directives.");
            }
            if (this.m_imports[impIdx].getAttributes() == null) continue;
            versionAttr = null;
            for (attrIdx = 0; attrIdx < this.m_imports[impIdx].getAttributes().length; ++attrIdx) {
                if (this.m_imports[impIdx].getAttributes()[attrIdx].getName().equals("version")) {
                    versionAttr = this.m_imports[impIdx].getAttributes()[attrIdx];
                    continue;
                }
                this.m_logger.log(2, "Unknown R3 import attribute: " + this.m_imports[impIdx].getAttributes()[attrIdx].getName());
            }
            if (versionAttr != null && this.m_imports[impIdx].getAttributes().length > 1) {
                this.m_imports[impIdx] = new R4Import(this.m_imports[impIdx].getName(), null, new R4Attribute[]{versionAttr});
                continue;
            }
            if (versionAttr != null || this.m_imports[impIdx].getAttributes().length <= 0) continue;
            this.m_imports[impIdx] = new R4Import(this.m_imports[impIdx].getName(), null, null);
        }
        HashMap<String, R4Import> map = new HashMap<String, R4Import>();
        for (i2 = 0; i2 < this.m_imports.length; ++i2) {
            map.put(this.m_imports[i2].getName(), this.m_imports[i2]);
        }
        for (i2 = 0; i2 < this.m_exports.length; ++i2) {
            if (map.get(this.m_exports[i2].getName()) != null) continue;
            map.put(this.m_exports[i2].getName(), new R4Import(this.m_exports[i2]));
        }
        this.m_imports = map.values().toArray(new R4Import[map.size()]);
        String usesValue = "";
        for (int i3 = 0; this.m_imports != null && i3 < this.m_imports.length; ++i3) {
            usesValue = usesValue + (usesValue.length() > 0 ? "," : "") + this.m_imports[i3].getName();
        }
        R4Directive uses = new R4Directive("uses", usesValue);
        for (i = 0; this.m_exports != null && i < this.m_exports.length; ++i) {
            this.m_exports[i] = new R4Export(this.m_exports[i].getName(), new R4Directive[]{uses}, this.m_exports[i].getAttributes());
        }
        for (i = 0; this.m_dynamics != null && i < this.m_dynamics.length; ++i) {
            if (this.m_dynamics[i].getDirectives().length != 0) {
                throw new BundleException("R3 dynamic imports cannot contain directives.");
            }
            if (this.m_dynamics[i].getAttributes().length == 0) continue;
            throw new BundleException("R3 dynamic imports cannot contain attributes.");
        }
    }

    private void checkAndNormalizeR4() throws BundleException {
        String symName = (String)this.m_headerMap.get("Bundle-SymbolicName");
        if (symName == null) {
            throw new BundleException("R4 bundle manifests must include bundle symbolic name.");
        }
        for (int i = 0; this.m_exports != null && i < this.m_exports.length; ++i) {
            String targetVer = (String)this.m_headerMap.get("Bundle-Version");
            targetVer = targetVer == null ? "0.0.0" : targetVer;
            R4Attribute[] attrs = this.m_exports[i].getAttributes();
            for (int attrIdx = 0; attrIdx < attrs.length; ++attrIdx) {
                if (!attrs[attrIdx].getName().equals("bundle-version") && !attrs[attrIdx].getName().equals("bundle-symbolic-name")) continue;
                throw new BundleException("Exports must not specify bundle symbolic name or bundle version.");
            }
            R4Attribute[] newAttrs = new R4Attribute[attrs.length + 2];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            newAttrs[attrs.length] = new R4Attribute("bundle-symbolic-name", symName, false);
            newAttrs[attrs.length + 1] = new R4Attribute("bundle-version", Version.parseVersion(targetVer), false);
            this.m_exports[i] = new R4Export(this.m_exports[i].getName(), this.m_exports[i].getDirectives(), newAttrs);
        }
    }

    public static R4Package[] parseImportExportHeader(String header) {
        Object[][][] clauses = ManifestParser.parseStandardHeader(header);
        HashMap<String, R4Attribute> attrMap = new HashMap<String, R4Attribute>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            attrMap.clear();
            for (int attrIdx = 0; attrIdx < clauses[clauseIdx][2].length; ++attrIdx) {
                R4Attribute attr = (R4Attribute)clauses[clauseIdx][2][attrIdx];
                attrMap.put(attr.getName(), attr);
            }
            R4Attribute v = (R4Attribute)attrMap.get("version");
            R4Attribute sv = (R4Attribute)attrMap.get("specification-version");
            if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                throw new IllegalArgumentException("Both version and specificat-version are specified, but they are not equal.");
            }
            if (sv == null) continue;
            attrMap.remove("specification-version");
            if (v != null) continue;
            attrMap.put("version", new R4Attribute("version", sv.getValue(), sv.isMandatory()));
            clauses[clauseIdx][2] = attrMap.values().toArray(new R4Attribute[attrMap.size()]);
        }
        ArrayList<R4Package> pkgList = new ArrayList<R4Package>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses[clauseIdx][0].length; ++pathIdx) {
                pkgList.add(new R4Package((String)clauses[clauseIdx][0][pathIdx], (R4Directive[])clauses[clauseIdx][1], (R4Attribute[])clauses[clauseIdx][2]));
            }
        }
        return pkgList.toArray(new R4Package[pkgList.size()]);
    }

    public static Object[][][] parseStandardHeader(String header) {
        Object[][][] clauses = null;
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            String[] clauseStrings = Util.parseDelimitedString(header, ",");
            ArrayList<Object[][]> completeList = new ArrayList<Object[][]>();
            for (int i = 0; clauseStrings != null && i < clauseStrings.length; ++i) {
                completeList.add(ManifestParser.parseStandardHeaderClause(clauseStrings[i]));
            }
            clauses = (Object[][][])completeList.toArray((T[])new Object[completeList.size()][][]);
        }
        return clauses == null ? new Object[][][]{} : clauses;
    }

    public static Object[][] parseStandardHeaderClause(String clauseString) throws IllegalArgumentException {
        String[] pieces = Util.parseDelimitedString(clauseString, ";");
        int pathCount = 0;
        for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
            ++pathCount;
        }
        if (pathCount == 0) {
            throw new IllegalArgumentException("No paths specified in header: " + clauseString);
        }
        String[] paths = new String[pathCount];
        System.arraycopy(pieces, 0, paths, 0, pathCount);
        HashMap<String, R4Directive> dirsMap = new HashMap<String, R4Directive>();
        HashMap<String, R4Attribute> attrsMap = new HashMap<String, R4Attribute>();
        int idx = -1;
        String sep = null;
        for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
            idx = pieces[pieceIdx].indexOf(":=");
            if (idx >= 0) {
                sep = ":=";
            } else {
                idx = pieces[pieceIdx].indexOf("=");
                if (idx >= 0) {
                    sep = "=";
                } else {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clauseString);
                }
            }
            String key = pieces[pieceIdx].substring(0, idx).trim();
            String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (sep.equals(":=")) {
                if (dirsMap.get(key) != null) {
                    throw new IllegalArgumentException("Duplicate directive: " + key);
                }
                dirsMap.put(key, new R4Directive(key, value));
                continue;
            }
            if (attrsMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            attrsMap.put(key, new R4Attribute(key, value, false));
        }
        R4Directive[] dirs = dirsMap.values().toArray(new R4Directive[dirsMap.size()]);
        R4Attribute[] attrs = attrsMap.values().toArray(new R4Attribute[attrsMap.size()]);
        Object[][] clause = new Object[][]{paths, dirs, attrs};
        return clause;
    }
}

