/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.moduleloader.JarFileX;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SecureAction {
    private static final ThreadLocal m_actions = new ThreadLocal(){

        public Object initialValue() {
            return new Actions();
        }
    };
    protected static transient int BUFSIZE = 4096;
    private AccessControlContext m_acc = AccessController.getContext();

    public String getSystemProperty(String name, String def) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(0, name, def);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return System.getProperty(name, def);
    }

    public Class forName(String name) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(1, name);
                return (Class)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return Class.forName(name);
    }

    public URL createURL(String protocol, String host, int port, String path, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(2, protocol, host, port, path, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(protocol, host, port, path, handler);
    }

    public URL createURL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(3, context, spec, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(context, spec, handler);
    }

    public String getAbsolutePath(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(4, file);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.getAbsolutePath();
    }

    public boolean fileExists(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(5, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.exists();
    }

    public boolean isFileDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(6, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.isDirectory();
    }

    public boolean mkdir(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(7, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdir();
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(8, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdirs();
    }

    public File[] listDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(9, file);
                return (File[])AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.listFiles();
    }

    public boolean renameFile(File oldFile, File newFile) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(10, oldFile, newFile);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return oldFile.renameTo(newFile);
    }

    public InputStream getFileInputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(11, file);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileInputStream(file);
    }

    public OutputStream getFileOutputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(12, file);
                return (OutputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileOutputStream(file);
    }

    public InputStream getURLConnectionInputStream(URLConnection conn) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(15, conn);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return conn.getInputStream();
    }

    public boolean deleteFile(File target) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(13, target);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return target.delete();
    }

    public JarFileX openJAR(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(14, file);
                return (JarFileX)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file);
    }

    public JarFile openJAR(File file, boolean verify) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(20, file, verify ? Boolean.TRUE : Boolean.FALSE);
                return (JarFile)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file);
    }

    public ContentClassLoader createContentClassLoader(ContentLoaderImpl impl) {
        return this.createContentClassLoader(impl, null);
    }

    public ContentClassLoader createContentClassLoader(ContentLoaderImpl impl, ProtectionDomain protectionDomain) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(16, impl, protectionDomain);
                return (ContentClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return new ContentClassLoader(impl, protectionDomain);
    }

    public void startActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(17, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.start(context);
        }
    }

    public void stopActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(18, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.stop(context);
        }
    }

    public void exit(int code) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(19, new Integer(code));
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else {
            System.exit(code);
        }
    }

    public Policy getPolicy() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(21, null);
                return (Policy)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return Policy.getPolicy();
    }

    private static class Actions
    implements PrivilegedExceptionAction {
        public static final int GET_PROPERTY_ACTION = 0;
        public static final int FOR_NAME_ACTION = 1;
        public static final int CREATE_URL_ACTION = 2;
        public static final int CREATE_URL_WITH_CONTEXT_ACTION = 3;
        public static final int GET_ABSOLUTE_PATH_ACTION = 4;
        public static final int FILE_EXISTS_ACTION = 5;
        public static final int FILE_IS_DIRECTORY_ACTION = 6;
        public static final int MAKE_DIRECTORY_ACTION = 7;
        public static final int MAKE_DIRECTORIES_ACTION = 8;
        public static final int LIST_DIRECTORY_ACTION = 9;
        public static final int RENAME_FILE_ACTION = 10;
        public static final int GET_FILE_INPUT_ACTION = 11;
        public static final int GET_FILE_OUTPUT_ACTION = 12;
        public static final int DELETE_FILE_ACTION = 13;
        public static final int OPEN_JARX_ACTION = 14;
        public static final int GET_URL_INPUT_ACTION = 15;
        public static final int CREATE_CONTENTCLASSLOADER_ACTION = 16;
        public static final int START_ACTIVATOR_ACTION = 17;
        public static final int STOP_ACTIVATOR_ACTION = 18;
        public static final int SYSTEM_EXIT_ACTION = 19;
        public static final int OPEN_JAR_ACTION = 20;
        public static final int GET_POLICY_ACTION = 21;
        private int m_action = -1;
        private Object m_arg1 = null;
        private Object m_arg2 = null;
        private String m_protocol = null;
        private String m_host = null;
        private int m_port = -1;
        private String m_path = null;
        private URLStreamHandler m_handler = null;

        private Actions() {
        }

        public void set(int action, Object arg1) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = null;
            this.m_protocol = null;
            this.m_host = null;
            this.m_port = -1;
            this.m_path = null;
            this.m_handler = null;
        }

        public void set(int action, Object arg1, Object arg2) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_protocol = null;
            this.m_host = null;
            this.m_port = -1;
            this.m_path = null;
            this.m_handler = null;
        }

        public void set(int action, String protocol, String host, int port, String path, URLStreamHandler handler) {
            this.m_action = action;
            this.m_protocol = protocol;
            this.m_host = host;
            this.m_port = port;
            this.m_path = path;
            this.m_handler = handler;
            this.m_arg1 = null;
            this.m_arg2 = null;
        }

        public void set(int action, URL context, String spec, URLStreamHandler handler) {
            this.m_action = action;
            this.m_arg1 = context;
            this.m_arg2 = spec;
            this.m_handler = handler;
        }

        private void unset() {
            this.m_action = -1;
            this.m_arg1 = null;
            this.m_arg2 = null;
            this.m_protocol = null;
            this.m_host = null;
            this.m_port = -1;
            this.m_path = null;
            this.m_handler = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            try {
                if (this.m_action == 0) {
                    String string = System.getProperty((String)this.m_arg1, (String)this.m_arg2);
                    return string;
                }
                if (this.m_action == 1) {
                    Class<?> clazz = Class.forName((String)this.m_arg1);
                    return clazz;
                }
                if (this.m_action == 2) {
                    URL uRL = new URL(this.m_protocol, this.m_host, this.m_port, this.m_path, this.m_handler);
                    return uRL;
                }
                if (this.m_action == 3) {
                    URL uRL = new URL((URL)this.m_arg1, (String)this.m_arg2, this.m_handler);
                    return uRL;
                }
                if (this.m_action == 4) {
                    String string = ((File)this.m_arg1).getAbsolutePath();
                    return string;
                }
                if (this.m_action == 5) {
                    Boolean bl = ((File)this.m_arg1).exists() ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 6) {
                    Boolean bl = ((File)this.m_arg1).isDirectory() ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 7) {
                    Boolean bl = ((File)this.m_arg1).mkdir() ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 8) {
                    Boolean bl = ((File)this.m_arg1).mkdirs() ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 9) {
                    File[] fileArray = ((File)this.m_arg1).listFiles();
                    return fileArray;
                }
                if (this.m_action == 10) {
                    Boolean bl = ((File)this.m_arg1).renameTo((File)this.m_arg2) ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 11) {
                    FileInputStream fileInputStream = new FileInputStream((File)this.m_arg1);
                    return fileInputStream;
                }
                if (this.m_action == 12) {
                    FileOutputStream fileOutputStream = new FileOutputStream((File)this.m_arg1);
                    return fileOutputStream;
                }
                if (this.m_action == 13) {
                    Boolean bl = ((File)this.m_arg1).delete() ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                if (this.m_action == 14) {
                    JarFileX jarFileX = new JarFileX((File)this.m_arg1);
                    return jarFileX;
                }
                if (this.m_action == 20) {
                    JarFile jarFile = new JarFile((File)this.m_arg1, (boolean)((Boolean)this.m_arg2));
                    return jarFile;
                }
                if (this.m_action == 15) {
                    InputStream inputStream = ((URLConnection)this.m_arg1).getInputStream();
                    return inputStream;
                }
                if (this.m_action == 16) {
                    ContentClassLoader contentClassLoader = new ContentClassLoader((ContentLoaderImpl)this.m_arg1, (ProtectionDomain)this.m_arg2);
                    return contentClassLoader;
                }
                if (this.m_action == 17) {
                    ((BundleActivator)this.m_arg1).start((BundleContext)this.m_arg2);
                    Object var1_19 = null;
                    return var1_19;
                }
                if (this.m_action == 18) {
                    ((BundleActivator)this.m_arg1).stop((BundleContext)this.m_arg2);
                    Object var1_20 = null;
                    return var1_20;
                }
                if (this.m_action == 19) {
                    System.exit((Integer)this.m_arg1);
                } else if (this.m_action == 21) {
                    Policy policy = Policy.getPolicy();
                    return policy;
                }
                Object var1_22 = null;
                return var1_22;
            }
            finally {
                this.unset();
            }
        }
    }
}

